      subroutine vecerr (n,x,xbar,normsw,vec,xnrm,xerr,temp)
c
      integer n,normsw
      real x(n),xbar(n),xnrm,xerr,temp(n)
      logical vec
c
c                                         Coded by Tom Rowan
c                            Department of Computer Sciences
c                              University of Texas at Austin
c
c vecerr computes the error in the vector xbar as an
c approximation to the vector x.
c
c input
c
c   n      - number of components
c
c   x      - real n-vector
c
c   xbar   - real n-vector
c
c   normsw - integer norm switch 
c            = 0 : use infinity-norm
c            = 1 : use 1-norm
c            = 2 : use 2-norm
c
c   vec    - logical switch
c            = .true.  : measure distance in vector sense
c            = .false. : measure distance in component sense
c
c   xnrm   - norm of x
c
c   temp   - real temporary array of dimension .ge. n
c
c output
c
c   xerr   - error in xbar as an approximation to x
c
c local variables
c
      integer i
      real vecnrm
c
c subroutines and functions
c
      external vecnrm
c
c-----------------------------------------------------------
c
      do 10 i = 1,n
        temp(i) = xbar(i)-x(i)
   10 continue
      if (vec) then
        xerr = vecnrm(n,temp,normsw)/xnrm
      else
        do 20 i = 1,n
          if (x(i) .ne. 0.) temp(i) = temp(i)/x(i)
   20   continue
        xerr = vecnrm(n,temp,normsw)
      end if
      return
      end
