      subroutine simplx (f,n,step,ns,ips,maxnfe,cmode,x,fx,
     *                   nfe,s,fs,iflag)
c
      integer n,ns,maxnfe,nfe,iflag
      integer ips(ns)
      real f,step(n),x(n),fx,s(ns,ns+3),fs(ns+1)
      logical cmode
c
c                                         Coded by Tom Rowan
c                            Department of Computer Sciences
c                              University of Texas at Austin
c
c simplx minimizes f on a subspace.
c
c input
c
c   f      - function to be minimized, declared external in
c            calling routine
c
c   n      - problem dimension
c
c   step   - stepsizes for corresponding elements of x
c
c   ns     - subspace dimension
c
c   ips    - permutation vector
c
c   maxnfe - maximum number of function evaluations
c
c   cmode  - logical switch
c            = .true.  : continuation of previous call
c            = .false. : first call
c
c   x      - starting guess for minimum
c
c   fx     - value of f at x
c
c   nfe    - number of function evaluations
c
c   s      - real work array of dimension .ge. ns*(ns+3)
c            used to store simplex
c
c   fs     - real work array of dimension .ge. ns+1 used 
c            to store function values of simplex vertices
c
c output
c
c   x      - computed minimum 
c
c   fx     - value of f at x
c
c   nfe    - incremented number of function evaluations
c
c   iflag  - error flag
c            = -1 : maxnfe exceeded
c            =  0 : simplex reduced by factor of psi
c            =  1 : limit of machine precision
c            =  2 : reached fstop
c
c common
c
      integer nsmin,nsmax,irepl,ifxsw,nfstop,nfxe
      real alpha,beta,gamma,delta,psi,omega,bonus,fstop,
     *     fxstat,ftest
      logical minf,initx,newx
c
      common /usubc/ alpha,beta,gamma,delta,psi,omega,nsmin,
     *               nsmax,irepl,ifxsw,bonus,fstop,nfstop,
     *               nfxe,fxstat(4),ftest,minf,initx,newx
c
      real fbonus,sfstop,sfbest
      logical new
c
      common /isubc/ fbonus,sfstop,sfbest,new
c
c local variables
c
      integer i,icent,ih,il,inew,is,itemp,j,npts
      real dist,dum,fc,fe,fr,tol
      logical small,updatc
c
      save
c
c subroutines and functions
c
      external f,calcc,dist,evalf,newpt,order,start
c   blas
      external scopy
c   fortran
      intrinsic min
c
c-----------------------------------------------------------
c
      if (cmode) go to 50
      npts = ns+1
      icent = ns+2
      itemp = ns+3
      updatc = .false.
      call start (n,x,step,ns,ips,s,small) 
      if (small) then
        iflag = 1
        return
      end if
      if (irepl .gt. 0) then
        new = .false.
        call evalf (f,ns,ips,s(1,1),n,x,fs(1),nfe)
      else
        fs(1) = fx
      end if
      new = .true.
      do 10 j = 2,npts
        call evalf (f,ns,ips,s(1,j),n,x,fs(j),nfe)
   10 continue
      il = 1
      call order (npts,fs,il,is,ih)
      tol = psi*dist(ns,s(1,ih),s(1,il))
c
c     main loop
c
   20 continue
        call calcc (ns,s,ih,inew,updatc,s(1,icent))
        updatc = .true.
        inew = ih
c
c       reflect
c
        call newpt (ns,alpha,s(1,icent),s(1,ih),.true.,
     *              s(1,itemp),small)
        if (small) go to 40
        call evalf (f,ns,ips,s(1,itemp),n,x,fr,nfe)
        if (fr .lt. fs(il)) then
c
c         expand
c
          call newpt (ns,-gamma,s(1,icent),s(1,itemp),
     *                .true.,s(1,ih),small)
          if (small) go to 40
          call evalf (f,ns,ips,s(1,ih),n,x,fe,nfe)
          if (fe .lt. fr) then
            fs(ih) = fe
          else 
            call scopy (ns,s(1,itemp),1,s(1,ih),1)
            fs(ih) = fr
          end if
        else if (fr .lt. fs(is)) then
c
c         accept reflected point
c
          call scopy (ns,s(1,itemp),1,s(1,ih),1)
          fs(ih) = fr
        else
c
c         contract
c
          if (fr .gt. fs(ih)) then
            call newpt (ns,-beta,s(1,icent),s(1,ih),.true.,
     *                  s(1,itemp),small)
          else
            call newpt (ns,-beta,s(1,icent),s(1,itemp),
     *                  .false.,dum,small)
          end if
          if (small) go to 40
          call evalf (f,ns,ips,s(1,itemp),n,x,fc,nfe)
          if (fc .lt. min(fr,fs(ih))) then
            call scopy (ns,s(1,itemp),1,s(1,ih),1)
            fs(ih) = fc
          else
c
c           shrink simplex
c
            do 30 j = 1,npts
              if (j .ne. il) then
                call newpt (ns,-delta,s(1,il),s(1,j),
     *                      .false.,dum,small)
                if (small) go to 40
                call evalf (f,ns,ips,s(1,j),n,x,fs(j),nfe)
              end if
   30       continue
          end if
          updatc = .false.
        end if
        call order (npts,fs,il,is,ih)
c
c       check termination
c
   40   continue
        if (irepl .eq. 0) then
          fx = fs(il)
        else
          fx = sfbest
        end if
   50   continue
        if (nfstop .gt. 0 .and. fx .le. sfstop .and.
     *      nfxe .ge. nfstop) then
          iflag = 2
        else if (nfe .ge. maxnfe) then
          iflag = -1
        else if (dist(ns,s(1,ih),s(1,il)) .le. tol .or.
     *           small) then
          iflag = 0
        else
          go to 20
        end if
c
c     end main loop, return best point
c
      do 60 i = 1,ns
        x(ips(i)) = s(i,il)
   60 continue
      return
      end
