      subroutine rsign (ixsize,delta,ix,rdelta)
c
      integer ixsize,ix
      real delta,rdelta
c
c                                         Coded by Tom Rowan
c                            Department of Computer Sciences
c                              University of Texas at Austin
c
c rsign assigns a random sign to a specified magnitude.
c The method generates the next bit in a random sequence of
c bits with period 2**ixsize.  For details see
c Knuth, D. E. (1981) The Art of Computer Programming,
c Volume 2: Seminumerical Algorithms, 2nd edition
c Addison-Wesley, pages 29-31 and exercise 3.2.2-7.
c
c input
c
c   ixsize - number of bits in logical word containing ix
c
c   delta  - magnitude of signed result
c
c   ix     - integer seed value satisfying 0 .le. ix .lt. 
c            2**ixsize, normally not reset between 
c            invocations of rsign
c
c output
c
c   ix     - new seed value
c
c   rdelta - signed result
c
c local variables
c
      integer ia(14),iatmp,ixtmp,i2pwr
c
c subroutines and functions
c
c   fortran
      intrinsic mod
c
c data
c
      data ia /1,3,3,3,5,3,15,29,27,27,123,123,111,95/
c
c-----------------------------------------------------------
c
      if (ix .gt. 0) then
        ix = ix*2
        i2pwr = 2**ixsize
        if (ix .ge. i2pwr) then 
          ix = ix-i2pwr
          if (ix .gt. 0) then
            iatmp = ia(ixsize)
            ixtmp = ix
            i2pwr = 1
   10       continue
            if (iatmp .gt. 0) then
              if (mod(iatmp,2) .eq. 1) then
                if (mod(ixtmp,2) .eq. 1) then
                  ix = ix-i2pwr
                else
                  ix = ix+i2pwr
                end if
              end if
              iatmp = iatmp/2
              ixtmp = ixtmp/2
              i2pwr = i2pwr*2
              go to 10
            end if
          end if
        end if
      else
        ix = ia(ixsize)
      end if
      if (mod(ix,2) .eq. 1) then
        rdelta = delta
      else
        rdelta = -delta
      end if
      return
      end
