      subroutine pertrb (n,x,delta,rel,ix,xbar)
c
      integer n,ix
      real x(n),delta,xbar(n)
      logical rel
c
c                                         Coded by Tom Rowan
c                            Department of Computer Sciences
c                              University of Texas at Austin
c
c pertrb generates a perturbation to the vector x.
c
c input
c
c   n      - number of components
c
c   x      - real n-vector
c
c   delta  - magnitude of perturbation
c
c   rel    - logical switch
c            = .true.  : generate relative perturbations
c            = .false. : generate absolute perturbations
c
c   ix     - integer seed value
c
c output
c
c   ix     - new seed value
c
c   xbar   - perturbation to x	
c
c local variables
c
      integer i,ixsize,ix2
      real rdelta
c
c subroutines and functions
c
      external rsign
c   fortran
      intrinsic min
c
c-----------------------------------------------------------
c
      ixsize = min(n,14)
      call rsign (ixsize,delta,ix,rdelta)
      ix2 = ix
      if (rel) then
        xbar(1) = x(1)*(1.+rdelta)
        do 10 i = 2,n
          call rsign (ixsize,delta,ix2,rdelta)
          xbar(i) = x(i)*(1.+rdelta)
   10   continue
      else
        xbar(1) = x(1)+rdelta
        do 20 i = 2,n
          call rsign (ixsize,delta,ix2,rdelta)
          xbar(i) = x(i)+rdelta
   20   continue
      end if
      return
      end
