      subroutine order (npts,fs,il,is,ih)
c
      integer npts,il,is,ih
      real fs(npts)
c
c                                         Coded by Tom Rowan
c                            Department of Computer Sciences
c                              University of Texas at Austin
c
c order determines the indices of the vertices with the
c lowest, second highest, and highest function values.
c
c input
c
c   npts   - number of points in simplex
c
c   fs     - real vector of function values of simplex 
c
c   il     - index to vertex with lowest function value
c
c output
c
c   il     - new index to vertex with lowest function value
c
c   is     - new index to vertex with second highest
c            function value
c
c   ih     - new index to vertex with highest function value
c
c local variables
c
      integer i,j
c
c subroutines and functions
c
c   fortran
      intrinsic mod
c
c-----------------------------------------------------------
c
      j = mod(il,npts)+1
      if (fs(j) .ge. fs(il)) then
        ih = j
        is = il
      else
        ih = il
        is = j
        il = j
      end if
      do 10 i = il+1,il+npts-2
        j = mod(i,npts)+1
        if (fs(j) .ge. fs(ih)) then
          is = ih
          ih = j
        else if (fs(j) .gt. fs(is)) then
          is = j
        else if (fs(j) .lt. fs(il)) then
          il = j
        end if
   10 continue
      return
      end
