      subroutine instab (nx,ny,mode,istab,normx,normy,
     *                  xbound,bestop,tol,maxnfe,scale,x,
     *                  bex,nfe,iwork,iflag)
c
      integer nx,ny,mode,istab,normx,normy,maxnfe,nfe,
     *        iwork(*),iflag
      real xbound,bestop,tol,scale(*),x(*),bex
c
c                                         Coded by Tom Rowan
c                            Department of Computer Sciences
c                              University of Texas at Austin
c
c instab uses functional stability analysis to detect
c instability in numerical algorithms. Functional stability
c analysis maximizes an estimate of a lower bound on the
c backward error over the space of problems to be solved. 
c A large lower bound on the backward error indicates that 
c the numerical algorithm is unstable. The function berror
c estimates the lower bound on the backward error. The
c subroutine subplx, implementing the subplex method, 
c maximizes the function berror.
c
c instab sets default options by calling the subroutine
c beaopt.  The user can override these defaults by calling
c beaopt prior to calling instab, changing the appropriate
c common variables, and setting the value of mode as 
c indicated below.
c
c The user supplies the subroutines approx(nx,x,ny,y,feas)
c and exact(nx,x,ny,y,feas). The routine approx serves as
c the interface between instab and the numerical algorithm
c being tested for instability.  Within approx, the real
c nx-vector x is used as input for the user's numerical
c algorithm.  approx must set the logical flag feas equal
c to .true. if x is feasible, and equal to .false.
c otherwise.  If the input x is feasible, the output from
c the numerical algorithm is stored in the real ny-vector
c y.  exact is similar to approx but exact returns a more
c accurate solution as output. A common way to implement
c exact is to use a higher-precision version of the
c numerical algorithm used in approx.
c
c input
c
c   nx     - number of real input variables 
c
c   ny     - number of real output variables
c  
c   mode   - integer mode switch with binary expansion
c            (bit 2) (bit 1) (bit 0)  :
c            bit 0 = 0 : first call to instab
c                  = 1 : continuation of previous call
c            bit 1 = 0 : use default options
c                  = 1 : user set options
c            bit 2 = 0 : optimization mode
c                  = 1 : single-step mode
c
c   istab  - integer switch that indicates sense of
c            stability, with binary expansion
c            (bit 1) (bit 0)  :
c            bit 0 = 0 : generate relative input 
c                        perturbations
c                  = 1 : generate absolute input 
c                        perturbations
c            bit 1 = 0 : measure distance in output space
c                        in vector sense
c                  = 1 : measure distance in output space
c                        in component sense
c
c   normx  - integer norm switch for input space
c            = 0 : use infinity-norm
c            = 1 : use 1-norm
c            = 2 : use 2-norm
c
c   normy  - integer norm switch for output space
c            = 0 : use infinity-norm
c            = 1 : use 1-norm
c            = 2 : use 2-norm
c
c   xbound - upper bound on magnitude of components of x,
c            used to limit region of search
c            (not used if xbound .le. 0.)
c
c   bestop - threshold value for bex that causes instab to
c            terminate when reached
c
c   tol    - relative error tolerance for x (tol .ge. 0.)
c
c   maxnfe - maximum number of function evaluations
c
c   scale  - scale and initial stepsizes for corresponding
c            components of x
c            (If scale(1) .lt. 0.,
c            abs(scale(1)) is used for all components of x,
c            and scale(2),...,scale(n) are not referenced.)
c
c   x      - real array containing numerical algorithm's
c            initial input in its first nx locations,
c            dimensioned  .ge.  
c            4*(nx+ny) + nsmax*(nsmax+4) + 1
c            (nsmax is set in subroutine beaopt.
c            default: nsmax = min(5,n))
c
c   iwork  - integer work array of dimension  .ge.  
c            nx + int(nx/nsmin)
c            (nsmin is set in subroutine beaopt.
c            default: nsmin = min(2,n))
c
c output
c
c   x      - numerical algorithm's final input
c
c   bex    - estimate of lower bound on backward error at x
c
c   nfe    - number of function evaluations
c
c   iflag  - error flag
c            = -2 : invalid input
c            = -1 : maxnfe exceeded
c            =  0 : tol satisfied
c            =  1 : limit of machine precision
c            =  2 : bestop reached
c            iflag should not be reset between calls to
c            instab.
c
c common
c
      integer nsmin,nsmax,irepl,ifxsw,nfstop,nfxe
      real alpha,beta,gamma,delta,psi,omega,bonus,fstop,
     *     fxstat,ftest
      logical minf,initx,newx
c
      common /usubc/ alpha,beta,gamma,delta,psi,omega,nsmin,
     *               nsmax,irepl,ifxsw,bonus,fstop,nfstop,
     *               nfxe,fxstat(4),ftest,minf,initx,newx
c
      integer ncmin,ncmax,ieysw,icndsw,neyemx,neye,nce
      real exmin,exmax,sdlgmn,sdlgmx,beval,eystat,cstat
c
      common /ubeac/ exmin,exmax,ncmin,ncmax,sdlgmn,sdlgmx,
     *               beval,ieysw,icndsw,neyemx,neye,nce,
     *               eystat(3),cstat(5)
c
      integer nrmxsw,nrmysw,nysav,ixbar,iy,iybar,iyhat,
     *        iybest,nc
      real eps,bound,tfac,onenrm
      logical estbe,estfe,estcnd,constr,exrel,eyvec
c
      common /ibeac/ eps,estbe,estfe,estcnd,constr,exrel,
     *               eyvec,nrmxsw,nrmysw,nysav,ixbar,iy,
     *               iybar,iyhat,iybest,bound,tfac,onenrm,nc
c
c local variables
c
      integer modes
      real berror,dum,epslon,vecnrm
      logical defopt,first,init,optmiz
c
      save
c
c subroutines and functions
c
      external beaopt,berror,epslon,fstats,subplx,vecnrm
c   blas
      external scopy
c   fortran
      intrinsic min,mod
c
c data
c
      data init /.true./
c
c-----------------------------------------------------------
c
      if (init) then
c
c       calculate machine epsilon
c
        eps = epslon(dum)
        init = .false.
      endif
      first = mod(mode,2) .eq. 0
      defopt = mod(mode/2,2) .eq. 0
      optmiz = mod(mode/4,2) .eq. 0
      if (first) then
c
c       first call, check input
c
        if (istab .lt. 0 .or. istab .gt. 3) go to 10
        if (normx .lt. 0 .or. normx .gt. 2) go to 10
        if (normy .lt. 0 .or. normy .gt. 2) go to 10
        if (defopt) then
          call beaopt (nx)
        else
          if (exmin .le. 0. .or. exmax .lt. exmin) go to 10
          if (ncmin .lt. 0 .or. ncmax .lt. ncmin) go to 10
          if (sdlgmx .lt. sdlgmn) go to 10
          if (minf) then
            if (beval .le. 0.) go to 10
          else
            if (beval .ge. 0.) go to 10
          end if
          if (ieysw .lt. 1 .or. ieysw .gt. 3) go to 10
          if (icndsw .lt. 1 .or. icndsw .gt. 3) go to 10
          if (neyemx .lt. 0 .or. 
     *        neyemx .gt. 2**(min(nx,14)-1)+1) go to 10
        end if
c
c       initialization
c
        estfe = neyemx .gt. 0
        estcnd = ncmax .gt. 0
        estbe = estfe .and. estcnd
        if (estbe) then
          if (icndsw .eq. 1) then
            ifxsw = 1
          else if (icndsw .eq. 2) then
            ifxsw = 3
          else
            ifxsw = 2
          end if
        else if (estfe) then
          ifxsw = ieysw
        else if (estcnd) then
          ifxsw = icndsw
        else
          go to 10
        end if
        constr = xbound .gt. 0.
        exrel = mod(istab,2) .eq. 0
        eyvec = mod(istab/2,2) .eq. 0
        nrmxsw = normx
        nrmysw = normy
        nysav = ny
        ixbar = 3*nx+nsmax*(nsmax+4)+2
        iy = ixbar+nx
        iybar = iy+ny
        iyhat = iybar+ny
        iybest = iyhat+ny
        bound = xbound
        tfac = (exmax-exmin)/16383.      
        if (.not. exrel) then
          call scopy (nx,1.,0,x(ixbar),1)
          onenrm = vecnrm(nx,x(ixbar),nrmxsw)
        end if
        nc = ncmin
      end if
      fstop = bestop
      if (optmiz) then
c
c       optimization mode
c
        modes = mod(mode,2)+2
        call subplx (berror,nx,tol,maxnfe,modes,scale,x,bex,
     *               nfe,x(nx+1),iwork,iflag)
      else
c
c       single-step mode
c
        if (first) then
          ftest = 0.
          initx = .true.
          newx = .true.
          nfe = 1
        else
          initx = .not. defopt
          newx = initx
          nfe = nfe+1
        end if
        bex = berror(nx,x)
        if (irepl .eq. 1) then
          call fstats (bex,1,newx)
          if (.not. newx) bex = fxstat(ifxsw)
        end if
        iflag = 0
      end if
      return
c
c     invalid input
c      
   10 continue
      iflag = -2
      return
      end
