      real function berror (nx,x)
c
      integer nx
      real x(*)
c
c                                         Coded by Tom Rowan
c                            Department of Computer Sciences
c                              University of Texas at Austin
c
c berror estimates a lower bound on the backward error.
c
c input
c
c   nx     - problem dimension
c
c   x      - real array of dimension .ge.
c            4*(nx+nysav) + nsmax*(nsmax+4) + 1,
c            containing input vector in first nx locations
c
c common
c
      integer nsmin,nsmax,irepl,ifxsw,nfstop,nfxe
      real alpha,beta,gamma,delta,psi,omega,bonus,fstop,
     *     fxstat,ftest
      logical minf,initx,newx
c
      common /usubc/ alpha,beta,gamma,delta,psi,omega,nsmin,
     *               nsmax,irepl,ifxsw,bonus,fstop,nfstop,
     *               nfxe,fxstat(4),ftest,minf,initx,newx
c
      real fbonus,sfstop,sfbest
      logical new
c
      common /isubc/ fbonus,sfstop,sfbest,new
c
      integer ncmin,ncmax,ieysw,icndsw,neyemx,neye,nce
      real exmin,exmax,sdlgmn,sdlgmx,beval,eystat,cstat
c
      common /ubeac/ exmin,exmax,ncmin,ncmax,sdlgmn,sdlgmx,
     *               beval,ieysw,icndsw,neyemx,neye,nce,
     *               eystat(3),cstat(5)
c
      integer nrmxsw,nrmysw,nysav,ixbar,iy,iybar,iyhat,
     *        iybest,nc
      real eps,bound,tfac,onenrm
      logical estbe,estfe,estcnd,constr,exrel,eyvec
c
      common /ibeac/ eps,estbe,estfe,estcnd,constr,exrel,
     *               eyvec,nrmxsw,nrmysw,nysav,ixbar,iy,
     *               iybar,iyhat,iybest,bound,tfac,onenrm,nc
c
c local variables
c
      integer i,ibar,ihat,isamax,iseedb(3),iseedn(2),nccnt,
     *        ncesv,neycnt,nfxcnt
      real cond(3),condlg,c4sv,dum,eyhat,exbar,exfac,eybar,
     *     tberr,tcond,vecnrm,ybnrm,ynrm
      logical feas,newbst,nofeas
c
      save
c
c subroutines and functions
c
      external approx,exact,fstats,pertrb,rsign,vecerr,
     *         vecnrm
c   blas
      external isamax,scopy
c   fortran
      intrinsic abs,log10,max,min,sqrt
c
c-----------------------------------------------------------
c
      if (newx) then
c
c       first evaluation at this point
c
        if (constr .and. abs(x(isamax(nx,x,1))) .gt. bound)
     *      go to 60
        if (exrel) then
          do 10 i = 1,nx
            if (x(i) .eq. 0.) go to 60
   10     continue
        else
          exfac = vecnrm(nx,x,nrmxsw)/onenrm
          if (exfac .eq. 0.) go to 60
        end if
c
c       calculate true solution
c
        call exact (nx,x,nysav,x(iy),feas)
        if (.not. feas) go to 60
        if (eyvec) then
          ynrm = vecnrm(nysav,x(iy),nrmysw)
          if (ynrm .eq. 0.) go to 60
        end if
c
c       calculate forward error
c
        neycnt = 0
        if (estfe) then
          call approx (nx,x,nysav,x(iyhat),feas)
          if (.not. feas) go to 60
          call vecerr (nysav,x(iy),x(iyhat),nrmysw,eyvec,
     *                 ynrm,eyhat,x(iyhat))
          neycnt = 1
        end if
c
c       estimate condition
c
        iseedn(1) = 0
        iseedn(2) = 0
        nccnt = 0
        if (estcnd) then
          do 20 i = 1,nc
            exbar = iseedn(1)*tfac+exmin       
            call rsign (14,1.,iseedn(1),dum)
            if (exrel) then
              call pertrb (nx,x,exbar,exrel,iseedn(2),
     *                     x(ixbar))
            else
              call pertrb (nx,x,exbar*exfac,exrel,iseedn(2),
     *                     x(ixbar))
            end if
            call exact (nx,x(ixbar),nysav,x(iybar),feas)
            if (feas) then
              nccnt = nccnt+1
              call vecerr (nysav,x(iy),x(iybar),nrmysw,
     *                     eyvec,ynrm,eybar,x(iybar))
              if (nccnt .eq. 1) then
                call scopy (3,eybar/exbar,0,cond,1)
              else
                tcond = eybar/exbar
                cond(1) = cond(1)+(tcond-cond(1))/nccnt
                cond(2) = max(cond(2),tcond)
                cond(3) = min(cond(3),tcond)
              end if
            end if
   20     continue
          if (nccnt .eq. 0) go to 60
        end if
c
c       estimate lower bound on backward error
c
        if (estbe) then
          if (cond(icndsw) .gt. 0.) then
            berror = eyhat/cond(icndsw)
          else
            berror = eyhat
          end if
        else if (estfe) then
          berror = eyhat
        else
          berror = cond(icndsw)
        end if
        nofeas = .false.
c
c       if new best point, reset stats
c
        if (minf) then
          newbst = berror .lt. ftest
        else
          newbst = berror .gt. ftest
        end if
        if (initx .or. newbst) then
          call scopy (nysav,x(iy),1,x(iybest),1)
          ybnrm = ynrm
          if (neycnt .gt. 0) then
            neye = neycnt
            call scopy (3,eyhat,0,eystat,1)
          end if
          if (nccnt .gt. 0) then
            nce = nccnt
            call scopy (3,cond,1,cstat,1)
            if (cond(icndsw) .gt. 0.) then
              condlg = log10(cond(icndsw))
            else
              condlg = 0.
            end if
            cstat(4) = condlg
            cstat(5) = 0.
          end if
          if (estcnd) then
            nfxcnt = nccnt
          else
            nfxcnt = neycnt
          end if
          call fstats (berror,nfxcnt,newx)
          iseedb(1) = iseedn(1)
          iseedb(2) = iseedn(2)
          iseedb(3) = 0
        end if
      else
c
c       replicated evaluation at this point
c
        if (nofeas) go to 60
c
c       calculate forward error, update forward-error stats
c
        neycnt = 0
        if (neye .lt. neyemx) then 
          x(ixbar) = x(1)*(1.-eps)
          if (nx .gt. 1) call pertrb (nx-1,x(2),eps,.true.,
     *                                iseedb(3),x(ixbar+1))
          call approx (nx,x(ixbar),nysav,x(iybar),feas)
          if (feas) then
            ibar = ixbar
            do 30 i = 1,nx
              x(ibar) = x(i)+(x(i)-x(ibar))
              ibar = ibar+1
   30       continue
            call approx (nx,x(ixbar),nysav,x(iyhat),feas)
            if (feas) then    
              ihat = iyhat
              do 40 ibar = iybar,iybar+nysav-1
                x(ihat) = x(ihat)+(x(ibar)-x(ihat))/2.
                ihat = ihat+1
   40         continue
              call vecerr (nysav,x(iybest),x(iyhat),nrmysw,
     *                     eyvec,ybnrm,eyhat,x(iyhat))
              neye = neye+1
              eystat(1) = eystat(1)+(eyhat-eystat(1))/neye    
              eystat(2) = max(eystat(2),eyhat)
              eystat(3) = min(eystat(3),eyhat)
              neycnt = 1
            end if
          end if
        end if
c
c       estimate condition, update condition stats
c
        nccnt = 0
        if (estcnd) then
          do 50 i = 1,nc
            exbar = iseedb(1)*tfac+exmin   
            call rsign (14,1.,iseedb(1),dum)
            if (exrel) then
              call pertrb (nx,x,exbar,exrel,iseedb(2),
     *                     x(ixbar))
            else
              call pertrb (nx,x,exbar*exfac,exrel,iseedb(2),
     *                     x(ixbar)) 
            end if
            call exact (nx,x(ixbar),nysav,x(iybar),feas)
            if (feas) then
              nccnt = nccnt+1
              call vecerr (nysav,x(iybest),x(iybar),nrmysw,
     *                     eyvec,ybnrm,eybar,x(iybar))
              if (nccnt .eq. 1) then
                call scopy (3,eybar/exbar,0,cond,1)
              else
                tcond = eybar/exbar
                cond(1) = cond(1)+(tcond-cond(1))/nccnt
                cond(2) = max(cond(2),tcond)
                cond(3) = min(cond(3),tcond)
              end if
            end if
   50     continue
          if (nccnt .gt. 0) then
            ncesv = nce
            c4sv = cstat(4)
            nce = nce+nccnt
            cstat(1) = cstat(1)+nccnt*((cond(1)-cstat(1))/
     *                                 nce)
            cstat(2) = max(cstat(2),cond(2))
            cstat(3) = min(cstat(3),cond(3))
            if (cond(icndsw) .gt. 0.) then
              condlg = log10(cond(icndsw))
            else
              condlg = 0.
            end if
            cstat(4) = cstat(4)+nccnt*((condlg-cstat(4))/
     *                                 nce)
            cstat(5) = sqrt(((ncesv-1)*cstat(5)**2+
     *                       ncesv*(cstat(4)-c4sv)**2+
     *                       nccnt*(condlg-cstat(4))**2)
     *                       /(nce-1))
            nc = min(max(int(ncmin+(ncmax-ncmin)*(cstat(5)-
     *           sdlgmn)/(sdlgmx-sdlgmn)),ncmin),ncmax)
          end if
        end if
c
c       estimate lower bound on backward error, 
c       update backward error stats
c
        if (estcnd) then
          nfxcnt = nccnt
        else 
          nfxcnt = neycnt
        end if
        if (nfxcnt .gt. 0) then
          if (estbe) then
            if (neycnt .eq. 0) eyhat = eystat(ieysw)
            if (cond(icndsw) .gt. 0.) then
              tberr = eyhat/cond(icndsw)
            else
              tberr = eyhat
            end if
          else if (estfe) then
            tberr = eyhat
          else 
            tberr = cond(icndsw)
          end if
          call fstats (tberr,nfxcnt,newx)
        end if
c
c       return improved estimate of lower bound on backward
c       error
c
        if (estbe) then
          if (cstat(icndsw) .gt. 0.) then
            berror = eystat(ieysw)/cstat(icndsw)
          else
            berror = eystat(ieysw)
          end if
        else if (estfe) then
          berror = eystat(ieysw)
        else
          berror = cstat(icndsw)
        end if
      end if
      return
c
c     infeasible point
c
   60 continue
      berror = beval
      if (initx) then
        call fstats (berror,1,.true.)
        nofeas = .true.
      end if
      return
      end
