/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:11 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "svecp.h"
#include <float.h>
#include <stdio.h>
#include <stdlib.h>
void /*FUNCTION*/ svecp(
float v[],
long n,
char *text)
{
	long int _l0, iblock, j, j1, j2, mode, nblock;
	static long maxcol[2]={8,6};
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	long *const Maxcol = &maxcol[0] - 1;
	float *const V = &v[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*     SVECP..  Print a vector.
	 * Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 2001-05-25 SVECP Krogh Minor change for making .f90 version.
	 *>> 1996-04-27 SVECP Krogh  Changes to use .C. and C%%.
	 *>> 1996-03-30 SVECP Krogh  Added external statement.
	 *>> 1996-01-24 SVECP Krogh  M77CON instructions for conversion to C.
	 *>> 1995-11-20 SVECP Krogh  Changes for conversion to C.
	 *>> 1994-10-20 SVECP Krogh  Changes to use M77CON
	 *>> 1994-08-08 SVECP CLL Special treatment for text(1:1) .eq. '0'
	 *>> 1994-04-20 CLL Making DP & SP codes similar.
	 *>> 1992-04-22 CLL
	 *>> 1985-09-20 CLL
	 *>> 1983-07-05 SVECP  K. Stewart   recoded for math 77 library
	 *>> 1981-07-23 SVECP  Kris Stewart RECODED FOR PORTABLE ENVIRONMENT
	 *>> 1969-00-00 C. L. Lawson, JPL, Original code: MOUT/VOUT
	 *     ------------------------------------------------------------------
	 *                  Subroutine arguments
	 *
	 *  V(I),I=1,N    Vector to be output.
	 *  N             Number of vector components.
	 *  TEXT   Character string to be printed as a title.
	 *         First character in TEXT controls line spacing before title on
	 *         an impact printer.  For output to be viewed on a screen it is
	 *         safest to always use ' '.
	 *         ' ' = normal single space.
	 *         '0' = double space.
	 *         '1' = page advance.
	 *         '+' = suppress space, i.e., overprint.
	 *     ------------------------------------------------------------------
	 *  Method:  If the machine epsilon, is larger than 0.5*10**(-12), we set
	 *    MODE = 1 and print 8 numbers across a line, using a g15.7 format.
	 *    Otherwise we set MODE = 2 and print 6 numbers across a line, using
	 *    a g20.12 format.
	 *     ------------------------------------------------------------------
	 *--S replaces "?": ?VECP
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------
	 *++ CODE for ~.C. is inactive
	 *      if(text(1:1) .eq. '0') then
	 *         write(*,'(/1x,a)') text(2:)
	 *      else
	 *         write(*,'(a)') text
	 *      endif
	 *++ CODE for .C. is active */
    if(text[0] == '0') printf("\n %s\n", &text[1]);
    else  printf("%s\n", text);
	if (FLT_EPSILON/FLT_RADIX > 0.5e-12)
	{
		/*++ END */
		mode = 1;
	}
	else
	{
		mode = 2;
	}
 
	nblock = (n + Maxcol[mode] - 1)/Maxcol[mode];
	j2 = 0;
 
	for (iblock = 1; iblock <= nblock; iblock++)
	{
		j1 = j2 + 1;
		j2 = min( j1 + Maxcol[mode] - 1, n );
		if (mode == 1)
		{
			printf(" %3ld TO %3ld", j1, j2);
			printf(" ");
			for (j = j1; j <= j2; j++)
			{
				printf("%15.7g", V[j]);
			}
			printf("\n");
		}
		else
		{
			printf(" %3ld TO %3ld", j1, j2);
			printf(" ");
			for (j = j1; j <= j2; j++)
			{
				printf("%20.12g", V[j]);
			}
			printf("\n");
		}
	}
	return;
} /* end of function */
 
