/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:11 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "stgset.h"
#include <stdlib.h>
void /*FUNCTION*/ stgset(
long j,
long t1,
long t2,
long t3,
long p1,
long p2,
long p3,
long triang[],
long mt)
{
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	long *const Triang = &triang[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *  File: STGSET.[F|FOR] CONTAINS STGSET, STGGET, STGPUT, STGSIZ.
	 *
	 *     THE FOUR SUBROUTINES STGGET, STGPUT, STGSET, AND STGSIZ MUST
	 *     BE MUTUALLY COMPATIBLE WITH REGARD TO THE METHOD OF PACKING
	 *     POINTERS IN TRIANG().
	 *
	 *     IN THIS VERSION ONLY ONE POINTER IS STORED PER WORD FOR MAXIMUM
	 *     PORTABILITY.
	 *
	 *>> 1996-02-02 STGSET CLL
	 *>> 1995-01-11 STGSET CLL Editing for inclusion into MATH77.
	 *     INPUT..  J AND THE INTEGERS T1,T2,T3,P1,P2,P3 DEFINING THE
	 *              JTH TRIANGLE.
	 *     THIS SUBR PUTS THIS INFO INTO THE ARRAY TRIANG().
	 *     C.L.LAWSON, JPL, 1979 JULY 22
	 *     ------------------------------------------------------------------
	 *--S replaces "?": ?TGSET, ?TGGET, ?TGPUT, ?TGSIZ
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	Triang[6*j - 5] = t1;
	Triang[6*j - 4] = t2;
	Triang[6*j - 3] = t3;
	Triang[6*j - 2] = p1;
	Triang[6*j - 1] = p2;
	Triang[6*j] = p3;
	return;
} /* end of function */
/*     ================================================================== */
void /*FUNCTION*/ stgget(
long j,
long tj[],
long triang[])
{
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	long *const Tj = &tj[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*     INPUT: J, TRIANG().
	 *     THIS SUBR FETCHES THE JTH TRIANGLE FROM TRIANG() AND STORES IT
	 *     IN TJ(1:6).
	 *     C.L.LAWSON, JPL, 1979 JULY 22
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	Tj[1] = triang[6*j - 5-(1)];
	Tj[2] = triang[6*j - 4-(1)];
	Tj[3] = triang[6*j - 3-(1)];
	Tj[4] = triang[6*j - 2-(1)];
	Tj[5] = triang[6*j - 1-(1)];
	Tj[6] = triang[6*j-(1)];
	return;
} /* end of function */
/*     ================================================================== */
void /*FUNCTION*/ stgput(
long j,
long tj[],
long triang[],
long mt)
{
 
	/*     INPUT MT=DIMENSION OF TRIANG()
	 *     INPUT J AND TJ(1:6).    THIS SUBR PUTS THE CONTENTS OF
	 *     TJ(1:6) INTO THE ARRAY TRIANG() TO DEFINE THE JTH TRIANGLE.
	 *     C.L.LAWSON, JPL, 1979 JULY 22
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	triang[6*j - 5-(1)] = tj[0];
	triang[6*j - 4-(1)] = tj[1];
	triang[6*j - 3-(1)] = tj[2];
	triang[6*j - 2-(1)] = tj[3];
	triang[6*j - 1-(1)] = tj[4];
	triang[6*j-(1)] = tj[5];
	return;
} /* end of function */
/*     ================================================================== */
void /*FUNCTION*/ stgsiz(
long mt,
long *ntlim)
{
 
	/*     INPUT..     MT = DIMENSION OF ARRAY TRIANG()
	 *     OUTPUT..    NTLIM = MAX NUMBER OF TRIANGLES WHOSE DESCRIPTION
	 *                 POINTERS CAN BE STORED IN TRIANG().  THERE ARE SIX
	 *                 POINTERS PER TRIANGLE.
	 *     C.L.LAWSON, JPL, 1979 JULY 22
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	*ntlim = mt/6;
	return;
} /* end of function */
 
