/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:31:59 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "sprpl2.h"
#include <stdlib.h>
void /*FUNCTION*/ sprpl2(
float *xy,
long idim,
long kc,
long jx[],
long jy[],
long np[],
byte symbol[],
char *title,
char *xname,
char *yname,
long nlines,
long nchars,
byte image[],
long *ierr)
{
#define XY(I_,J_)	(*(xy+(I_)*(idim)+(J_)))
#define IMAGE(I_,J_)	(image+(I_)*(nchars)+(J_))
	long int bottom, i, iline, jx1, jy1, k, l1, left, right, top;
	float facx, facy, x1, x2, xmax, xmin, y1, y2, ymax, ymin;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	long *const Jx = &jx[0] - 1;
	long *const Jy = &jy[0] - 1;
	long *const Np = &np[0] - 1;
	byte *const Symbol = &symbol[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 2011-11-29 DRPPL2 Krogh  Fixed comments for arguments.
	 *>> 1994-10-20 SPRPL2 Krogh  Changes to use M77CON
	 *>> 1994-08-05 SPRPL2 CLL Replaced 0.5 with 0.5001 for more consistent
	 *              rounding on different computers.
	 *>> 1992-02-14 SPRPL2  CLL
	 *>> 1988-05-24 CLL
	 *     1969 CLL and Jack Hatfield wrote KCPL & KCPLA for the JPL UNIVAC
	 *          LIB*JPL$ library.
	 *     1983 CLL and Stella Chan made Fortran 77 version, PRPL2.
	 *     1992-02-10 CLL.  Major changes to let user set NLINES and NCHAR.
	 *     ------------------------------------------------------------------
	 *                             SUBROUTINE ARGUMENTS
	 *
	 *  XY(,) Array of values from which $(x,\ y)$ coordinates of points
	 *        to be placed will be obtained under control of the parameters
	 *        JX(), JY(), and NP().
	 *
	 *  IDIM  Dimension of the first subscript in the XY array. Require IDIM
	 *        .ge. \max {NP(k), 1 .le. k .le. KC.
	 *
	 *  KC    Number of XY sets to be plotted. If KC .le. 0, the subroutine
	 *        will return taking no action.
	 *
	 *  JX()  JX(k) specifies the column (second subscript) of XY(,) to be
	 *        used as the x coordinates for the k-th xy set.
	 *
	 *  JY()  JY(k) specifies the column (second subscript) of XY(,) to be
	 *        used as the y coordinates for the k-th  xy set.
	 *
	 *  NP()  NP(k) specifies the number of xy pairs from XY(,) in the k-th
	 *        set to be plotted.
	 *
	 *  SYMBOL() SYMBOL(k) is the single character to be used for
	 *        point-plotting the k-th data set.
	 *
	 *   TITLE     Character string to be
	 *             printed above the plot grid as a title for the
	 *             graph.
	 *
	 *   XNAME     Character string to be
	 *             printed below the plot grid to identify the
	 *             abscissa variable.
	 *
	 *   YNAME     Character string to be
	 *             printed in a vertical column at the left of the
	 *             plot grid to identify the ordinate variable.
	 *
	 *   NLINES [in] Number of lines available for the output image.
	 *
	 *   NCHARS [in]  Number of characters per line available for the
	 *          output image.
	 *   IMAGE() [out,array of chars]  Array of at least NLINES elements,
	 *      each being a character variable of length at least NCHARS.
	 *      This subr will build the output plot image in this array.
	 *   IERR [out,integer]  Termination status indicator.  0 means ok.
	 *      1 means need larger NCHARS.  2 means need larger NLINES.
	 *     ------------------------------------------------------------------
	 *--S replaces "?": ?PRPL2, ?PRPL3
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------
	 *
	 *                          Find min's and max's of data values.
	 * */
	x1 = XY(Jx[1] - 1,0);
	x2 = x1;
	y1 = XY(Jy[1] - 1,0);
	y2 = y1;
	for (k = 1; k <= kc; k++)
	{
		jx1 = Jx[k];
		jy1 = Jy[k];
		for (i = 1; i <= Np[k]; i++)
		{
			x2 = fmaxf( x2, XY(jx1 - 1,i - 1) );
			x1 = fminf( x1, XY(jx1 - 1,i - 1) );
			y2 = fmaxf( y2, XY(jy1 - 1,i - 1) );
			y1 = fminf( y1, XY(jy1 - 1,i - 1) );
		}
	}
 
	/*        Subroutine SPRPL3 determine data values for the first and last
	 *        grid lines:  XMIN, XMAX,    YMIN, YMAX,
	 *        and corresponding index values for use in the character array
	 *        IMAGE()():   LEFT, RIGHT,   BOTTOM, TOP,
	 *        and constructs grid lines, labels, and titles in IMAGE()().
	 * */
	sprpl3( x1, x2, y1, y2, &xmin, &xmax, &ymin, &ymax, &left, &right,
	 &bottom, &top, title, xname, yname, nlines, nchars, image,
	 ierr );
 
	/*        Plot the xy data points.
	 *        Note: (BOTTOM - TOP) will be positive.
	 * */
	facx = (float)( right - left )/(xmax - xmin);
	facy = (float)( bottom - top )/(ymax - ymin);
	for (k = 1; k <= kc; k++)
	{
		jx1 = Jx[k];
		jy1 = Jy[k];
		for (i = 1; i <= Np[k]; i++)
		{
			iline = bottom - (long)( (XY(jy1 - 1,i - 1) - ymin)*facy +
			 0.5001e0 );
			l1 = left + (long)( (XY(jx1 - 1,i - 1) - xmin)*facx +
			 0.5001e0 );
			IMAGE(iline - 1,0)[l1 - 1] = Symbol[k];
		}
	}
	return;
#undef	IMAGE
#undef	XY
} /* end of function */
 
