/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:10 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "sprpl.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	HALF	0.5e0
#define	ONE	1.0e0
#define	ZERO	0.0e0
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ sprpl(
float y,
byte symbol,
byte image[],
long nchar,
float y1,
float y2,
LOGICAL32 reset)
{
	long int jy, jz;
	float a, b, c, dz, fjz, fnc, zmax, zmin;
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *
	 *>> 1997-05-24 DPRRL Krogh  Changes to use .C. and C%%.
	 *>> 1996-01-19 SPRPL Krogh  Changes to automate conversion to C.
	 *>> 1994-10-20 SPRPL Krogh  Changes to use M77CON
	 *>> 1994-08-05 SPRPL CLL Use C = 1.5001 instead of 1.5
	 *>> 1992-05-12 CLL Avoid use of sign function.
	 *>> 1990-10-10 WV Snyder JPL Don't overflow in test for zero in interval
	 *>> 1988-06-24 CLL
	 *     ------------------------------------------------------------------
	 *     SUBROUTINE ARGUMENTS
	 *     --------------------
	 *     Y         Data values to be plotted.
	 *
	 *     SYMBOL    Single character to be used as plot
	 *               symbol.
	 *
	 *     IMAGE     Character variables in which plot image is
	 *               to be constructed.
	 *
	 *     NCHAR     Number of character positions in the
	 *               array IMAGE() to be used as a plot
	 *               symbol.
	 *
	 *     Y1,Y2     Numbers that bracket the range of
	 *               values of Y to be plotted in IMAGE().
	 *
	 *     RESET     Flag to reset the line image.If RESET
	 *               = .TRUE. the subroutine will:
	 *               1) Store NCHAR blank characters into
	 *                  IMAGE().
	 *               2) Store the character '0' in the zero
	 *                  value position if zero is contained
	 *                  in the interval [ZMIN,ZMAX].
	 *               3) Store the character specified by
	 *                  SYMBOL in the Y value position.
	 *
	 *               If RESET = .FALSE. the subroutine will
	 *               only execute Step 3 above.
	 *
	 *     ------------------------------------------------------
	 *
	 *     1969 July 9,programmed by C.L.Lawson,JPL
	 *     1981 change Hollerith characters to Fortran 77
	 *          characters,K.Stewart,JPL
	 *     1983 coded for Fortran 77,C.L.Lawson,S.Chan,JPL
	 *     1988-06-24 CLL Made DP version.
	 *     1992-05-12 CLL Noted that '0' was not being placed in IMAGE in
	 *       some cases when it should have on VAX and Unisys.  Was due to
	 *       branching on the sign of ZMIN which could be zero.  Changed
	 *       code to avoid use of the sign function.
	 *     1994-08-05 CLL Use C = 1.5001 instead of 1.5 to improve
	 *       consistency of symbol placement on different computers.
	 *     ------------------------------------------------------------------
	 *--S replaces "?": ?PRPL
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	zmin = fminf( y1, y2 );
	zmax = fmaxf( y1, y2 );
	dz = zmax - zmin;
 
	/*     Change ZMIN,ZMAX to avoid DZ=0
	 * */
	if (dz == ZERO)
	{
		if (zmin == ZERO)
		{
			zmin = -ONE;
			zmax = ONE;
		}
		else
		{
			zmin *= 0.9e0;
			zmax *= 1.1e0;
		}
		dz = zmax - zmin;
	}
 
	fnc = (float)( nchar );
 
	/*     Compute A,B,C to define linear transformation
	 * */
	a = zmin;
	b = (fnc - ONE)/dz;
	c = 1.5001e0;
 
	/*     Set JZ = index of zero using the current A, B, C.
	 *     if this JZ is in the plotting range, exclusive of the end points,
	 *     i.e., if 1 .lt. JZ .lt. NCHAR, then recompute A,B,C to make zero
	 *     fall in the center of its descretization interval.  This will
	 *     cause data values that are symmetric around zero to plot at
	 *     locations that are symmetric around the zero location.
	 * */
	jz = -a*b + c;
	if (jz > 1 && jz < nchar)
	{
		fjz = (float)( jz );
		a = ZERO;
		c = fjz + HALF;
		b = fminf( (fnc - fjz)/zmax, (ONE - fjz)/zmin );
	}
 
	/*     End..compute A,B,C,JZ
	 * */
	if (reset)
	{
      for(jy = 0; jy <= nchar-1; jy++)  image[jy] = ' ';
         image[nchar] = '\0';
		if (jz >= 1 && jz <= nchar)
			image[jz - 1] = '0';
		/*        if (NCHAR .ne. 0) IMAGE(1:NCHAR)= ' ' */
	}
 
	/*     Process Y
	 * */
	jy = (y - a)*b + c;
	if (jy > 0)
	{
		if (jy <= nchar)
		{
			image[jy - 1] = symbol;
		}
		else if (nchar >= 3)
		{
       image[nchar-3]='O'; image[nchar-2]='U'; image[nchar-1]='T';
		}
		/*          IMAGE(NCHAR-2:NCHAR)='OUT' */
	}
	else if (nchar >= 3)
	{
       image[0]='O'; image[1]='U'; image[2]='T';
	}
	/*        IMAGE(1:3)='OUT' */
	return;
} /* end of function */
 
