/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:09 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "sdaswt.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	ISMOOT	13
#define	ITOL	2
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ sdaswt(
long neq,
long info[],
float rtol[],
float atol[],
float y[],
float wt[],
float rwork[],
long iwork[])
{
	long int i;
	float atoli, exmp, exmpm1, rtoli, tol0;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const Atol = &atol[0] - 1;
	long *const Info = &info[0] - 1;
	long *const Iwork = &iwork[0] - 1;
	float *const Rtol = &rtol[0] - 1;
	float *const Rwork = &rwork[0] - 1;
	float *const Wt = &wt[0] - 1;
	float *const Y = &y[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 2006, Math a la Carte, Inc.
	 *>> 2003-03-11 sdaswt Hanson moved Soderlind's changes to ATOL, RTOL her
	 *>> 2003-03-06 sdaswt Hanson started using reciprocal weights
	 *>> 2001-11-23 sdaswt Krogh  Changed many names per library conventions.
	 *>> 2001-11-04 sdaswt Krogh  Fixes for F77 and conversion to single
	 *>> 2001-11-01 sdaswt Hanson Provide code to Math a la Carte.
	 *--S replaces "?": ?daswt, ?daslx
	 *      IMPLICIT NONE
	 ****BEGIN PROLOGUE  SDASWT
	 ****SUBSIDIARY
	 ****PURPOSE  Set error weight vector for SDASLX.
	 ****LIBRARY   SLATEC (SDASLX)
	 ****TYPE      DOUBLE PRECISION (SDASWT-S, SDASWT-D)
	 ****AUTHOR  Petzold, Linda R., (LLNL)
	 ****DESCRIPTION
	 * ----------------------------------------------------------------------
	 *     THIS SUBROUTINE SETS THE ERROR WEIGHT VECTOR
	 *     WT ACCORDING TO WT(I)=RTOL(I)*ABS(Y(I))+ATOL(I),
	 *     I=1,-,N.
	 *     RTOL AND ATOL ARE SCALARS IF IWT = 0,
	 *     AND VECTORS IF IWT = 1.
	 * ----------------------------------------------------------------------
	 ****ROUTINES CALLED  (NONE)
	 ****REVISION HISTORY  (YYMMDD)
	 *   830315  DATE WRITTEN
	 *   901009  Finished conversion to SLATEC 4.0 format (F.N.Fritsch)
	 *   901019  Merged changes made by C. Ulrich with SLATEC 4.0 format.
	 *   901026  Added explicit declarations for all variables and minor
	 *           cosmetic changes to prologue.  (FNF)
	 ****END PROLOGUE  SDASWT
	 * */
 
	/*SM */
	/*SM
	 *
	 ****FIRST EXECUTABLE STATEMENT  SDASWT */
	for (i = 1; i <= neq; i++)
	{
		if (Info[ITOL] != 0)
		{
			rtoli = Rtol[i];
			atoli = Atol[i];
		}
		else
		{
			rtoli = Rtol[1];
			atoli = Atol[1];
		}
		if (Info[ISMOOT] == 0)
		{
			tol0 = 1.0e-5;
 
			exmp = 7.0e0/9.0e0;
			exmpm1 = exmp - 1.0e0;
			atoli = powf(tol0,exmpm1/exmp)*powf(atoli,1.0e0/exmp);
			rtoli = powf(tol0,exmpm1/exmp)*powf(rtoli,1.0e0/exmp);
			/*          ATOLI=min(5.E-3,ATOLI)
			 *          RTOLI=min(5.E-3,RTOLI) */
		}
		Wt[i] = 1.e0/(rtoli*fabsf( Y[i] ) + atoli);
		/*SM */
	}
	return;
	/* -----------END OF SUBROUTINE SDASWT ---------------------------------- */
} /* end of function */
 
