/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:31:58 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "scspxx.h"
#include <float.h>
#include <stdlib.h>
float /*FUNCTION*/ scspxx(
float x)
{
	long int _l0, j, k, n;
	float f, g, scspxx_v;
	static float bigx = -1.0e0;
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 2001-07-16 SCSPXX Krogh  -1.0 changed to -1.E0.
	 *>> 1998-10-29 SCSPXX Krogh  Moved external statement up for mangle.
	 *>> 1996-01-08 SCSPXX WV Snyder Original code
	 *--S replaces "?": ?CSPXX, ?COSPX, ?SINPX */
	/* COS(PI * X * X / 2) carefully to avoid loss of precision for large X */
	/* SCOSPX is used to compute COS(PI * X) */
	/* BIGX = 1 / round-off = biggest integer exactly representable by F.P.
	 *    If X > BIGX then to the working precision x**2 is an integer (which
	 *    we assume to be a multiple of four), so cos(pi/2 * x**2) = 1.
	 * N = [X], and later [K F]
	 * F = X - N = fractional part of X
	 * K = [ N / 2 ]
	 * J = N mod 2
	 * M = [K F]
	 * G = K F - M = fractional part of K F */
	if (bigx < 0.0e0)
		bigx = 1.0e0/FLT_EPSILON;
	f = fabsf( x );
	if (f > bigx)
	{
		/*       Assume x is an even integer. */
		scspxx_v = 1.0e0;
		return( scspxx_v );
	}
	n = f;
	f -= n;
	k = n/2;
	j = n%2;
	g = k*f;
	n = g;
	g -= n;
	if (j == 0)
	{
		scspxx_v = scospx( 0.5e0*f*f + g + g );
	}
	else
	{
		scspxx_v = -ssinpx( 0.5e0*f*f + f + g + g );
	}
	return( scspxx_v );
} /* end of function */
 
