/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:31:45 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "scpint.h"
#include <stdlib.h>
void /*FUNCTION*/ scpint(
float a[],
long na,
float b[],
long *nb)
{
	long int j, k, nbp1;
	float d1, d2, fac;
	static float zero = 0.e0;
	static float half = .5e0;
	static float two = 2.e0;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const A = &a[0] - 1;
	float *const B = &b[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-11-11 SCPINT Krogh   Declared all vars.
	 *>> 1994-10-20 SCPINT Krogh  Changes to use M77CON
	 *>> 1987-12-09 SCPINT Lawson  Initial code.
	 *--S replaces "?": ?CPINT */
 
	/*     INTEGRATION OF FINITE CHEBYSHEV SERIES
	 *     C.L.LAWSON, JPL, 1973 JULY 18
	 *
	 *     (A(I),I=1,2)       SCALE FACTORS .
	 *     (A(I+2),I=1,NA+1)  COEFS OF CHEBY SERIES .
	 *     NA                 DEGREE OF CHEBY SERIES .
	 *     (B(I),I=1,2)       OUTPUT..  SCALE FACTORS .
	 *     (B(I+2),I=1,NB+1)  OUTPUT..  COEFS DEFINING INTEGRATED
	 *                                  SERIES .
	 *     NB                 OUTPUT..  DEGREE OF SERIES
	 * */
	if (na < 0)
	{
		ierm1( "SCPINT", 1, 0, "REQUIRE NA .GE. 0", "NA", na, '.' );
	}
	else
	{
		B[1] = A[1];
		B[2] = A[2];
		*nb = na + 1;
		d2 = zero;
		if (*nb != 1)
		{
			d1 = zero;
			fac = 2**nb;
			for (j = 1; j <= na; j++)
			{
				B[na + 5 - j] = (A[na + 4 - j] - d2)/fac;
				d2 = d1;
				d1 = A[na + 4 - j];
				fac -= two;
			}
		}
		B[4] = A[3] - half*d2;
		B[3] = zero;
		nbp1 = *nb + 1;
		for (k = 1; k <= nbp1; k++)
		{
			B[k + 2] *= B[2];
		}
	}
	return;
} /* end of function */
 
