/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:07 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dzabs.h"
#include <stdlib.h>
/*++ Replace "DZABS" = .Y.//.N.//"ABS" */
		/* PARAMETER translations */
#define	ONE	1.0e0
#define	ZERO	0.0e0
		/* end of PARAMETER translations */
 
double /*FUNCTION*/ dzabs(
double z[])
{
	double a, b, dzabs_v;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const Z = &z[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1995-10-30 DZABS  Krogh   Fixed so M77CON can get S.P. for C conv.
	 *>> 1987-12-07 DZABS  Lawson  Initial code.
	 *--Z replaces "?":
	 *
	 *     Returns sqrt(Z(1)**2 + Z(2)**2)
	 *     Lawson and Chiu, JPL, Oct 1987
	 * */
 
	a = fabs( Z[1] );
	b = fabs( Z[2] );
	if (a > b)
	{
		dzabs_v = a*sqrt( ONE + powi(b/a,2) );
	}
	else if (b != ZERO)
	{
		dzabs_v = b*sqrt( ONE + powi(a/b,2) );
	}
	else
	{
		dzabs_v = ZERO;
	}
	return( dzabs_v );
} /* end of function */
 
