/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:06 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "drot.h"
#include <stdlib.h>
void /*FUNCTION*/ drot(
long n,
double x[],
long incx,
double y[],
long incy,
double c,
double s)
{
	long int _d_l, _d_m, _do0, _do1, i, kx, ky, nsteps;
	double w, z;
	static double zero = 0.e0;
	static double one = 1.e0;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const X = &x[0] - 1;
	double *const Y = &y[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-11-11 DROT  Krogh   Declared all vars.
	 *>> 1994-10-20 DROT   Krogh  Changes to use M77CON
	 *>> 1985-08-02 DROT   Lawson  Initial code.
	 *--D replaces "?": ?ROT
	 *
	 *     MULTIPLY THE 2 X 2 MATRIX  ( C S) TIMES THE 2 X N MATRIX (X**T)
	 *                                (-S C)                        (Y**T)
	 *     WHERE **T INDICATES TRANSPOSE.    THE ELEMENTS OF X ARE IN
	 *     X(LX+I*INCX), I = 0 TO N-1, WHERE LX = 1 IF INCX .GE. 0, ELSE
	 *     LX = (-INCX)*N, AND SIMILARLY FOR Y USING LY AND INCY. */
 
	if (n <= 0 || (s == zero && c == one))
		goto L_40;
	if (!(incx == incy && incx > 0))
		goto L_20;
 
	nsteps = incx*n;
	for (i = 1, _do0=DOCNT(i,nsteps,_do1 = incx); _do0 > 0; i += _do1, _do0--)
	{
		w = X[i];
		z = Y[i];
		X[i] = c*w + s*z;
		Y[i] = -s*w + c*z;
	}
	goto L_40;
 
L_20:
	;
	kx = 1;
	ky = 1;
 
	if (incx < 0)
		kx = 1 - (n - 1)*incx;
	if (incy < 0)
		ky = 1 - (n - 1)*incy;
 
	for (i = 1; i <= n; i++)
	{
		w = X[kx];
		z = Y[ky];
		X[kx] = c*w + s*z;
		Y[ky] = -s*w + c*z;
		kx += incx;
		ky += incy;
	}
L_40:
	;
 
	return;
} /* end of function */
 
