/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:31:56 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dprpl1.h"
#include <stdlib.h>
void /*FUNCTION*/ dprpl1(
double x[],
double y[],
long np,
char *title,
char *xname,
char *yname,
long nlines,
long nchars,
byte image[],
long *ierr)
{
#define IMAGE(I_,J_)	(image+(I_)*(nchars)+(J_))
	long int bottom, i, iline, j, l1, left, right, top;
	double facx, facy, x1, x2, xmax, xmin, y1, y2, ymax, ymin;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const X = &x[0] - 1;
	double *const Y = &y[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-10-20 DPRPL1 Krogh  Changes to use M77CON
	 *>> 1994-08-05 DPRPL1 CLL Replaced 0.5 with 0.5001 for more consistent
	 *              rounding on different computers.
	 *>> 1992-02-14 DPRPL1 CLL Added choice of no. of rows & cols in output.
	 *>> 1990-10-29 PRPL1 CLL More changes to formatting of x-grid labels.
	 *>> 1990-10-22 PRPL1 CLL Added FAC, XSMALL, YSMALL.
	 *>> 1989-07-20 PRPL1  WV Snyder JPL Change ROW1 and ROW2 dimensions to *
	 *>> 1988-05-24 PRPL1  Lawson  Initial code.
	 *     DPRPL1  Enhanced version of PRPL1.  1992-01-29, CLL
	 *     PRPL1       This replaces EZPLTA of JPL$.
	 *     Only first 51 characters of YNAME() are used.
	 *     C.L.Lawson & Stella Chan,JPL,April 4,1983
	 *     Coded for Fortran 77.
	 *     1990 Oct.  Reworked formatting of labels for the x-grid lines.
	 *     No. of major subdivisions, KMAJX, returned by SCALK8 will be
	 *     3, 4, 5, 6, 7, or 8.  Generally we print KMAJX+1 labels, but print
	 *     only 5 for KMAJX = 8.
	 *     Will print numbers in the form -1.2345D-201 except when KMAJX = 7
	 *     in which case we reduce to     -1.234D-201.  Provides one or more
	 *     spaces between numbers.
	 *     Also reduced spacing between the ROW1() & ROW2() items.
	 *     ------------------------------------------------------------------
	 *                             SUBROUTINE ARGUMENTS
	 *
	 *   X(),Y()   Arrays of (x,y) coordinate pairs defining the
	 *             curve to be plotted.
	 *
	 *   NP        Number of (x,y) points to be plotted.
	 *
	 *   TITLE     Character string to be
	 *             printed above the plot grid as a title for the
	 *             graph.
	 *
	 *   XNAME     Character string to be
	 *             printed below the plot grid to identify the
	 *             abscissa variable.
	 *
	 *   YNAME     Character string to be
	 *             printed in a vertical column at the left of the
	 *             plot grid to identify the ordinate variable.
	 *
	 *   NLINES [in] Number of lines available for the output image.
	 *
	 *   NCHARS [in]  Number of characters per line available for the
	 *          output image.
	 *   IMAGE() [out,array of chars]  Array of at least NLINES elements,
	 *      each being a character variable of length at least NCHARS.
	 *      This subr will build the output plot image in this array.
	 *   IERR [out,integer]  Termination status indicator.  0 means ok.
	 *      1 means need larger NCHARS.  2 means need larger NLINES.
	 *     ------------------------------------------------------------------
	 *--D replaces "?": ?PRPL1, ?PRPL3
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------
	 *
	 *                          Find min's and max's of data values.
	 * */
	x1 = X[1];
	y1 = Y[1];
	x2 = x1;
	y2 = y1;
	for (i = 2; i <= np; i++)
	{
		x2 = fmax( x2, X[i] );
		x1 = fmin( x1, X[i] );
		y2 = fmax( y2, Y[i] );
		y1 = fmin( y1, Y[i] );
	}
 
	/*        Subroutine DPRPL3 determine data values for the first and last
	 *        grid lines:  XMIN, XMAX,    YMIN, YMAX,
	 *        and corresponding index values for use in the character array
	 *        IMAGE()():   LEFT, RIGHT,   BOTTOM, TOP,
	 *        and constructs grid lines, labels, and titles in IMAGE()().
	 * */
	dprpl3( x1, x2, y1, y2, &xmin, &xmax, &ymin, &ymax, &left, &right,
	 &bottom, &top, title, xname, yname, nlines, nchars, image,
	 ierr );
 
	/*        Plot the xy data points.
	 *        Note:  (BOTTOM - TOP) will be positive.
	 * */
	facx = (double)( right - left )/(xmax - xmin);
	facy = (double)( bottom - top )/(ymax - ymin);
	for (j = 1; j <= np; j++)
	{
		iline = bottom - (long)( (Y[j] - ymin)*facy + 0.5001e0 );
		l1 = left + (long)( (X[j] - xmin)*facx + 0.5001e0 );
		IMAGE(iline - 1,0)[l1 - 1] = '*';
	}
 
	return;
#undef	IMAGE
} /* end of function */
 
