/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:31:16 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dnlagb.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	D	27
#define	J	70
#define	NEXTV	47
#define	NFCALL	6
#define	NFGCAL	7
#define	R	61
#define	REGD0	82
#define	TOOBIG	2
#define	VNEED	4
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ dnlagb(
long n,
long p,
double x[],
double b[][2],
void (*dcalcr)(long,long,double[],long*,double[]),
void (*dcalcj)(long,long,double[],long*,double[]),
long iv[],
long liv,
long lv,
double v[])
{
	long int d1, dr1, iv1, n1, n2, nf, r1, rd1;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	long *const Iv = &iv[0] - 1;
	double *const V = &v[0] - 1;
	double *const X = &x[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1996-04-27 DNLAGB Krogh  Changes to get desired C prototypes.
	 *>> 1994-10-20 DNLAGB Krogh  Changes to use M77CON
	 *>> 1990-07-02 DNLAGB CLL @ JPL
	 *>> 1990-06-12 CLL @ JPL
	 *>> 1990-02-16 CLL @ JPL
	 *** from netlib, Wed Feb  7 13:51:26 EST 1990 ***
	 *
	 *  ***  VERSION OF NL2SOL THAT HANDLES SIMPLE BOUNDS ON X  ***
	 *
	 *  ***  PARAMETERS  ***
	 * */
 
	/*  ***  DISCUSSION  ***
	 *
	 *        NOTE... NL2SOL (MENTIONED BELOW) IS A CODE FOR SOLVING
	 *     NONLINEAR LEAST-SQUARES PROBLEMS.  IT IS DESCRIBED IN
	 *     ACM TRANS. MATH. SOFTWARE, VOL. 9, PP. 369-383 (AN ADAPTIVE
	 *     NONLINEAR LEAST-SQUARES ALGORITHM, BY J.E. DENNIS, D.M. GAY,
	 *     AND R.E. WELSCH).
	 *
	 *        LIV GIVES THE LENGTH OF IV.  IT MUST BE AT LEAST 82 + 4*P.
	 *     IF NOT, THEN DNLAGB RETURNS WITH IV(1) = 15.  When DNLAGB returns,
	 *     the minimum acceptable value of LIV is stored in
	 *     IV(LASTIV) = IV(44), (provided that LIV .ge. 44).
	 *
	 *        LV GIVES THE LENGTH OF V.  THE MINIMUM VALUE FOR LV IS
	 *     LV0 = 105 + P*(N + 2*P + 21) + 2*N.  IF LV IS SMALLER THAN THIS,
	 *     THEN DNLAGB RETURNS WITH IV(1) = 16.  WHEN DNLAGB RETURNS, THE
	 *     MINIMUM ACCEPTABLE VALUE OF LV IS STORED IN IV(LASTV) = IV(45)
	 *     (PROVIDED LIV .GE. 45).
	 *
	 *        RETURN CODES AND CONVERGENCE TOLERANCES ARE THE SAME AS FOR
	 *     NL2SOL, WITH SOME SMALL EXTENSIONS... IV(1) = 15 MEANS LIV WAS
	 *     TOO SMALL.   IV(1) = 16 MEANS LV WAS TOO SMALL.
	 *
	 *        THERE ARE TWO NEW V INPUT COMPONENTS...  V(LMAXS) = V(36) AND
	 *     V(SCTOL) = V(37) SERVE WHERE V(LMAX0) AND V(RFCTOL) FORMERLY DID
	 *     IN THE SINGULAR CONVERGENCE TEST -- SEE THE NL2SOL DOCUMENTATION.
	 *
	 *  ***  BOUNDS  ***
	 *
	 *     THE BOUNDS  B(1,I) .LE. X(I) .LE. B(2,I), I = 1(1)P, ARE ENFORCED.
	 *
	 *  ***  DEFAULT VALUES  ***
	 *
	 *        DEFAULT VALUES ARE PROVIDED BY SUBROUTINE DIVSET, RATHER THAN
	 *     DFAULT.  THE CALLING SEQUENCE IS...
	 *             CALL DIVSET(1, IV, LIV, LV, V)
	 *     THE FIRST PARAMETER IS AN INTEGER 1.  IF LIV AND LV ARE LARGE
	 *     ENOUGH FOR DIVSET, THEN DIVSET SETS IV(1) TO 12.  OTHERWISE IT
	 *     SETS IV(1) TO 15 OR 16.  CALLING DNLAGB WITH IV(1) = 0 CAUSES ALL
	 *     DEFAULT VALUES TO BE USED FOR THE INPUT COMPONENTS OF IV AND V.
	 *        IF YOU FIRST CALL DIVSET, THEN SET IV(1) TO 13 AND CALL DNLAGB,
	 *     THEN STORAGE ALLOCATION ONLY WILL BE PERFORMED.  IN PARTICULAR,
	 *     IV(D) = IV(27), IV(J) = IV(70), AND IV(R) = IV(61) WILL BE SET
	 *     TO THE FIRST SUBSCRIPT IN V OF THE SCALE VECTOR, THE JACOBIAN
	 *     MATRIX, AND THE RESIDUAL VECTOR RESPECTIVELY, PROVIDED LIV AND LV
	 *     ARE LARGE ENOUGH.  IF SO, THEN DNLAGB RETURNS WITH IV(1) = 14.
	 *     WHEN CALLED WITH IV(1) = 14, DNLAGB ASSUMES THAT STORAGE HAS
	 *     BEEN ALLOCATED, AND IT BEGINS THE MINIMIZATION ALGORITHM.
	 *
	 *  ***  SCALE VECTOR  ***
	 *
	 *        ONE DIFFERENCE WITH NL2SOL IS THAT THE SCALE VECTOR D IS
	 *     STORED IN V, STARTING AT A DIFFERENT SUBSCRIPT.  THE STARTING
	 *     SUBSCRIPT VALUE IS STILL STORED IN IV(D) = IV(27).  THE
	 *     DISCUSSION OF DEFAULT VALUES ABOVE TELLS HOW TO HAVE IV(D) SET
	 *     BEFORE THE ALGORITHM IS STARTED.
	 *
	 *  ***  GENERAL  ***
	 *
	 *     CODED BY DAVID M. GAY.
	 *
	 *  ***  EXTERNAL SUBROUTINES  ***
	 * */
	/*--D replaces "?": ?NLAGB, ?IVSET, ?RN2GB, ?CALCR, ?CALCJ
	 * DIVSET.... PROVIDES DEFAULT IV AND V INPUT COMPONENTS.
	 *  DRN2GB... CARRIES OUT OPTIMIZATION ITERATIONS.
	 *
	 *  ***  LOCAL VARIABLES  ***
	 * */
 
	/*  ***  IV COMPONENTS  ***
	 * */
	/*/6
	 *     DATA D/27/, J/70/, NEXTV/47/, NFCALL/6/, NFGCAL/7/, R/61/,
	 *    1     REGD0/82/, TOOBIG/2/, VNEED/4/
	 * /7 */
	/*/
	 * --------------------------------  BODY  ------------------------------
	 * */
	if (Iv[1] == 0)
		divset( 1, iv, liv, lv, v );
	iv1 = Iv[1];
	if (iv1 == 14)
		goto L_10;
	if (iv1 > 2 && iv1 < 12)
		goto L_10;
	if (iv1 == 12)
		Iv[1] = 13;
	if (Iv[1] == 13)
		Iv[VNEED] += p + n*(p + 2);
	drn2gb( b, x, v, iv, liv, lv, n, n, &n1, &n2, p, v, v, v, x );
	if (Iv[1] != 14)
		goto L_999;
 
	/*  ***  STORAGE ALLOCATION  ***
	 * */
	Iv[D] = Iv[NEXTV];
	Iv[R] = Iv[D] + p;
	Iv[REGD0] = Iv[R] + n;
	Iv[J] = Iv[REGD0] + n;
	Iv[NEXTV] = Iv[J] + n*p;
	if (iv1 == 13)
		goto L_999;
 
L_10:
	d1 = Iv[D];
	dr1 = Iv[J];
	r1 = Iv[R];
	rd1 = Iv[REGD0];
 
L_20:
	drn2gb( b, &V[d1], &V[dr1], iv, liv, lv, n, n, &n1, &n2, p, &V[r1],
	 &V[rd1], v, x );
	switch (IARITHIF(Iv[1] - 2))
	{
		case -1: goto L_30;
		case  0: goto L_50;
		case  1: goto L_999;
	}
 
	/*  ***  NEW FUNCTION VALUE (R VALUE) NEEDED  ***
	 * */
L_30:
	nf = Iv[NFCALL];
    (*dcalcr)( n, p, x, &nf, &V[r1] );
	if (nf > 0)
		goto L_40;
	/*      CALL DCALCR(N, P, X, NF, V(R1)) */
	Iv[TOOBIG] = 1;
	goto L_20;
L_40:
	if (Iv[1] > 0)
		goto L_20;
 
	/*  ***  COMPUTE DR = GRADIENT OF R COMPONENTS  ***
	 * */
L_50:
	;
    (*dcalcj)( n, p, x, &Iv[NFGCAL], &V[dr1] );
	if (Iv[NFGCAL] == 0)
		Iv[TOOBIG] = 1;
	/*      CALL DCALCJ(N, P, X, IV(NFGCAL), V(DR1)) */
	goto L_20;
 
L_999:
	return;
 
	/*  ***  LAST CARD OF   DNLAGB FOLLOWS  *** */
} /* end of function */
 
