/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:31:42 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dmpint.h"
#include <stdlib.h>
void /*FUNCTION*/ dmpint(
double a[],
long na,
double b[],
long *nb)
{
	long int i, nap3;
	double div;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const A = &a[0] - 1;
	double *const B = &b[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-11-15 CLL Edited to use M77CON.
	 *>> 1994-11-11 DMPINT  Krogh   Declared all vars.
	 *>> 1987-12-09 DMPINT Lawson  Initial code.
	 *
	 *     INDEFINITE INTEGRATION OF A POLYNOMIAL REPRESENTED BY COEFFS
	 *     RELATIVE TO THE MONOMIAL BASIS INCLUDING A LINEAR TRANSFORMATION
	 *     OF THE ARGUMENT.
	 *     C.L.LAWSON, JP, 1973 DEC 6
	 *
	 *     (A(I),I=1,2)       SCALE FACTORS
	 *     (A(I+2),I=1,NA+1)  COEFS OF POLY
	 *     NA                 DEGREE OF POLY
	 *     (B(I),I=1,2)       OUTPUT..  SCALE FACTORS
	 *     (B(I+2),I=1,NB+1   OUTPUT..  COEFS OF INTEGRATED
	 *                                  POLY
	 *     NB                 OUTPUT..  DEGREE OF POLY
	 *
	 *     ------------------------------------------------------------------
	 *--D replaces "?": ?MPINT
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	if (na < 0)
	{
		ierm1( "DMPINT", 1, 0, "REQUIRE NA .GE. 0", "NA", na, '.' );
	}
	else
	{
		B[1] = A[1];
		B[2] = A[2];
		nap3 = na + 3;
		*nb = nap3 - 2;
		B[3] = 0.e0;
		div = 0.e0;
		for (i = 3; i <= nap3; i++)
		{
			div += 1.e0;
			B[i + 1] = B[2]*A[i]/div;
		}
	}
	return;
} /* end of function */
 
