/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:18 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_ssbasd s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <stdio.h>
#include <stdlib.h>
#include "p_ssbasd.h"
/*      program DRSSBASD
 *>> 1996-07-09 DRSSBASD Krogh  Format changes for conversion to C.
 *>> 1994-10-19 DRSSBASD Krogh  Changes to use M77CON
 *>> 1993-01-12 DRSSBASD CLL @ JPL
 *>> 1992-11-12 CLL @ JPL
 *>> 1992-11-04 CLL @ JPL
 *   Demo driver for SSBASD, SSBASI, SSDIF, SSFIND, SSVALA.
 *     ------------------------------------------------------------------
 *--S replaces "?": DR?SBASD, ?SBASD, ?SBASI, ?SDIF, ?SFIND, ?SVALA
 *     ------------------------------------------------------------------ */
		/* PARAMETER translations */
#define	IDERIV	2
#define	KORDER	4
#define	NCOEF	6
#define	NDERIV	3
#define	X	0.4e0
#define	X1	0.1e0
#define	X2	0.9e0
		/* end of PARAMETER translations */
 
 
int main( )
{
	long int i, j1, j2, left, mode;
	float basi[NCOEF], bderiv[KORDER], bdif[NCOEF*NDERIV + 1], bvals[KORDER],
	 svalue[NDERIV + 1];
	static float tknots[KORDER + NCOEF]={0.0e0,0.0e0,0.0e0,0.0e0,0.3e0,
	 0.8e0,1.0e0,1.0e0,1.0e0,1.0e0};
	static float bcoef[NCOEF]={0.1e0,0.4e0,0.2e0,-0.3e0,-0.5e0,-0.2e0};
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const Basi = &basi[0] - 1;
	float *const Bcoef = &bcoef[0] - 1;
	float *const Bderiv = &bderiv[0] - 1;
	float *const Bdif = &bdif[0] - 1;
	float *const Bvals = &bvals[0] - 1;
	float *const Svalue = &svalue[0] - 1;
	float *const Tknots = &tknots[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*     ------------------------------------------------------------------ */
	printf(" DRSSBASD..  Demo driver for\n             SSBASD, SSBASI, SSDIF, SSFIND, SSVALA.\n    KORDER =%2d,  NCOEF =%2d",
	   KORDER, NCOEF);
	printf("\n    TKNOTS() =");
	for (i = 1; i <= (KORDER + NCOEF); i++)
	{
		printf("%5.1f", Tknots[i]);
	}
	printf("\n");
	printf(" Using SSFIND with X = %5.1f\n", X);
	left = 1;
	ssfind( tknots, KORDER, NCOEF + 1, X, &left, &mode );
	printf("    LEFT = %2ld,  MODE =%2ld\n", left, mode);
	printf(" Using SSBASD with IDERIV = 0\n");
	ssbasd( KORDER, left, tknots, X, 0, bvals );
	printf("    Values at X of basis functions indexed from %2ld to %2ld", left + 1 - KORDER,
	   left);
	printf("\n      ");
	for (i = 1; i <= KORDER; i++)
	{
		printf("%12.6f", Bvals[i]);
	}
	printf("\n");
	printf(" Using SSBASD with IDERIV =%2d\n", IDERIV);
	ssbasd( KORDER, left, tknots, X, IDERIV, bderiv );
	printf("    Values at X of 2nd deriv of basis functions indexed from %2ld to %2ld",
	   left + 1 - KORDER, left);
	printf("\n      ");
	for (i = 1; i <= KORDER; i++)
	{
		printf("%12.5f", Bderiv[i]);
	}
	printf("\n");
	printf(" Using SSBASI with X1 = %5.1f and X2 = %5.1f\n", X1, X2);
	j1 = 1;
	j2 = 1;
	ssbasi( KORDER, NCOEF, tknots, X1, X2, &j1, &j2, basi );
	printf("    J1 =%2ld,  J2 =%2ld", j1, j2);
	printf("\n    Integrals from X1 to X2 of basis functions:\n   ");
	for (i = 1; i <= NCOEF; i++)
	{
		printf("%11.6f", Basi[i]);
	}
	printf("\n");
	printf(" Using SSDIF and SSVALA with NDERIV =%2d", NDERIV);
	printf(" and\n    BCOEF() = ");
	for (i = 1; i <= NCOEF; i++)
	{
		printf("%5.1f", Bcoef[i]);
	}
	printf("\n");
	ssdif( KORDER, NCOEF, tknots, bcoef, NDERIV, bdif );
	ssvala( KORDER, NCOEF, tknots, NDERIV, bdif, X, svalue );
	printf("    Values of derivs 0 through %2d", NDERIV);
	printf(" at X: \n      ");
	for (i = 1; i <= (NDERIV + 1); i++)
	{
		printf("%11.6f", Svalue[i]);
	}
	printf("\n");
	exit(0);
} /* end of function */
 
