/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:12 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_dnqsol s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <float.h>
#include <stdio.h>
#include <stdlib.h>
#include "p_dnqsol.h"
/*     program DRDNQSOL
 *>> 1996-06-21 DRDNQSOL Krogh  Changes for C conversion.
 *>> 1994-11-02 DRDNQSOL Krogh  Changes to use M77CON
 *>> 1992-04-15 DRDNQSOL CLL.
 *>> 1992-01-14 CLL.
 *     Demo driver for DNQSOL.  Also using DCKDER.
 *     Expected solution vector:  0.9000518     1.0001835     1.0945009
 *     ------------------------------------------------------------------
 *--D replaces "?": DR?NQSOL, ?NQSOL, ?NRM2, ?CKDER, ?NQFJ
 *     ------------------------------------------------------------------ */
		/* PARAMETER translations */
#define	LWA	(3 + (15*NMAX + 3*NMAX*NMAX)/2)
#define	NMAX	3
		/* end of PARAMETER translations */
 
 
int main( )
{
	long int _l0, i, imax, iopt[5], j, jmax, m, mode;
	double fjac[NMAX][NMAX], fnorm, fvec[NMAX], test[NMAX][NMAX],
	 tol, tstmax, wa[LWA], x[NMAX];
	static long n = NMAX;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const Fvec = &fvec[0] - 1;
	long *const Iopt = &iopt[0] - 1;
	double *const Wa = &wa[0] - 1;
	double *const X = &x[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*     ------------------------------------------------------------------ */
	Iopt[4] = 0;
	tol = sqrt( DBL_EPSILON );
	X[1] = 3.0e0;
	X[2] = 3.0e0;
	X[3] = 3.0e0;
	printf("Program DRDNQSOL.  Demo driver for DNQSOL.  Also using DCKDER.\n");
 
	/*     ------------------------------------------------------------------
	 *               Using DCKDER to check derivative computation.
	 *     ------------------------------------------------------------------ */
	printf("\n Using DCKDER to check derivative computation.\n");
	m = n;
	dnqfj( n, x, fvec, (double*)fjac, ADR(_l0,2) );
	mode = 1;
L_10:
	;
	dckder( &mode, m, n, x, fvec, (double*)fjac, NMAX, (double*)test,
	 &imax, &jmax, &tstmax );
	if (mode == 2)
	{
		dnqfj( n, x, fvec, (double*)fjac, ADR(_l0,1) );
		goto L_10;
	}
	dnqfj( n, x, fvec, (double*)fjac, ADR(_l0,1) );
	printf("\n           X(J) =");
	for (j = 1; j <= n; j++)
	{
		printf("%11.3g", X[j]);
	}
	printf("\n");
	printf("\n   I    FVEC(I)   .....................FJAC(I,J)........................\n\n");
	for (i = 1; i <= m; i++)
	{
		printf(" %3ld %11.3g", i, Fvec[i]);
		printf(" ");
		for (j = 1; j <= n; j++)
		{
			printf("%11.3g", fjac[j - 1][i - 1]);
		}
		printf("\n");
	}
	printf("\n TEST(,):\n\n");
	for (i = 1; i <= m; i++)
	{
		printf(" %3ld", i);
		printf("             ");
		for (j = 1; j <= n; j++)
		{
			printf("%11.3g", test[j - 1][i - 1]);
		}
		printf("\n");
	}
	printf("\n IMAX =%3ld,    JMAX =%3ld,    TSTMAX =%11.3g\n", imax, jmax, tstmax);
 
	/*     ------------------------------------------------------------------
	 *           Using DNQSOL to solve system of nonlinear equations.
	 *     ------------------------------------------------------------------ */
	printf("\n Using DNQSOL to solve system of nonlinear equations.\n");
 
	dnqsol( dnqfj, n, x, fvec, tol, iopt, wa, LWA );
 
	fnorm = dnrm2( n, fvec, 1 );
	/*++ CODE for ~.C. is inactive
	 *      print'('' Termination status:  '',i6/'' NFEV, NJEV:          '',
	 *     * 2i6/ '' Final residual norm: '',g14.3/'' Final X():           ''
	 *     * /(8x,4f14.7))',  IOPT(1), IOPT(2), IOPT(3),
	 *     * FNORM, (X(J), J = 1, N)
	 *++ CODE for .C. is active */
   printf(" Termination status:  %6ld\n NFEV, NJEV:          "
      "%6ld%6ld\n Final residual norm: %14.3g\n Final X():           ", Iopt[1], Iopt[2],
      Iopt[3], fnorm);
   for (j = 0; j < n; j+=4){
      printf("\n        ");
      for (i = j; i < (j < n - 3 ? j + 4 : n); i++)
         printf("%14.7f", x[i]);}
   printf("\n");
	exit(0);
	/*++ END */
} /* end of function */
/*     ================================================================== */
void /*FUNCTION*/ dnqfj(
long n,
double x[],
double fvec[],
double *fjac,
long *iflag)
{
#define FJAC(I_,J_)	(*(fjac+(I_)*(n)+(J_)))
	long int i;
	static double c1[3]={-1.0e0,2.0e0,2.0e0};
	static double c2[3]={2.0e0,-1.0e0,2.0e0};
	static double c3[3]={2.0e0,2.0e0,-1.0e0};
	static double term[3]={5.01e0,5.85e0,8.88e0};
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const C1 = &c1[0] - 1;
	double *const C2 = &c2[0] - 1;
	double *const C3 = &c3[0] - 1;
	double *const Fvec = &fvec[0] - 1;
	double *const Term = &term[0] - 1;
	double *const X = &x[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*>> 1992-01-14 CLL.
	 *     Sample 3-dimensional function of 3 variables for demo of solution
	 *     of a system of nonlinear equations.
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	if (*iflag == 1)
	{
		/*                                        Compute function vector. */
		for (i = 1; i <= n; i++)
		{
			Fvec[i] = exp( C1[i]*X[1] ) + sinh( C2[i]*X[2] ) + tanh( C3[i]*
			 X[3] ) - Term[i];
		}
	}
	else if (*iflag == 2)
	{
		/*                                        Compute Jacobian matrix. */
		for (i = 1; i <= n; i++)
		{
			FJAC(0,i - 1) = exp( C1[i]*X[1] )*C1[i];
			FJAC(1,i - 1) = cosh( C2[i]*X[2] )*C2[i];
			FJAC(2,i - 1) = powi(1.0e0/cosh( C3[i]*X[3] ),2)*C3[i];
		}
	}
	return;
#undef	FJAC
} /* end of function */
 
