/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:11 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_dlnrel s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <float.h>
#include <stdio.h>
#include <stdlib.h>
#include "p_dlnrel.h"
#include "drdlnrel.h"
/*      program DRDLNREL
 *>> 1999-07-27 DRDLNREL Krogh analyz => DANAL for global analysis.
 *>> 1996-07-09 DRDLNREL Krogh Moved formats up.
 *>> 1994-11-02 DRDLNREL Krogh  Changes to use M77CON
 *>> 1994-07-06 DRDLNREL WVS set up for chgtyp
 *
 *     Demonstration driver for more accurate routines from chapter 2-15.
 *     To illustrate worst-case, expressions are computed little-by-
 *     little.  If possible, the routine should be compiled with an
 *     option that causes results not to be stored in registers from one
 *     assignment to the next.  For Lahey Fortran on a PC, use /7.
 *
 *--D replaces "?": DR?LNREL, ?GAMMA, ?LNREL, ?RLOG1, ?RLOG, ?REXP
 *--   &              ?SINPX, ?COSPX, ?SINHM, ?COSHM, ?CSHMM, ?GAM1
 *--   &              ?COS1, ?SIN1, ?ANAL */
		/* PARAMETER translations */
#define	DPI	3.141592653589793238462643383279502884197e0
		/* end of PARAMETER translations */
 
 
int main( )
{
	long int _l0;
	double d, u, w;
 
 
	/*     DLNREL */
	d = 1.0e0/powi(2.0e0,12);
	w = 1.0e0 + d;
	w = log( w );
	u = dlnrel( d );
	danal( "DLNREL", d, u, w );
 
	/*     DRLOG1 */
	w = d - w;
	u = drlog1( d );
	danal( "DRLOG1", d, u, w );
 
	/*     DRLOG */
	w = d - 1.0e0;
	w -= log( d );
	u = drlog( d );
	danal( "DRLOG ", d, u, w );
 
	/*     DREXP */
	w = exp( d );
	w -= 1.0e0;
	u = drexp( d );
	danal( "DREXP ", d, u, w );
 
	/*     DSINPX */
	d = 25.125e0;
	w = sin( d*DPI );
	u = dsinpx( d );
	danal( "DSINPX", d, u, w );
 
	/*     DCOSPX */
	w = cos( d*DPI );
	u = dcospx( d );
	danal( "DCOSPX", d, u, w );
 
	/*     DSIN1 */
	d = powi(0.5e0,22);
	w = sin( d );
	w = (d - w)/CUBE(d);
	u = dsin1( d );
	danal( "DSIN1 ", d, u, w );
 
	/*     DCOS1 */
	w = cos( d );
	w = (d - w)/SQ(d);
	u = dcos1( d );
	danal( "DCOS1 ", d, u, w );
 
	/*     DSINHM */
	d = 0.25e0;
	w = sinh( d );
	w -= d;
	u = dsinhm( d );
	danal( "DSINHM", d, u, w );
 
	/*     DCOSHM */
	w = cosh( d );
	w -= 1.0e0;
	u = dcoshm( d );
	danal( "DCOSHM", d, u, w );
 
	/*     DCSHMM */
	w = cosh( d );
	w -= 1.0e0;
	w += -0.5*d*d;
	u = dcshmm( d );
	danal( "DCSHMM", d, u, w );
 
	/*     DGAM1 */
	w = 1.0e0/dgamma( 1.0e0 + d );
	w -= 1.0e0;
	u = dgam1( d );
	danal( "DGAM1 ", d, u, w );
 
	printf(" Error is (relative error) / (round off level).\n Round off level is (smallest number r such that 1 + r .NE. 1).\n For the present machine, r =%13.6g\n Errors less than 0.5 r should be considered to be zero.\n",
	   DBL_EPSILON);
	exit(0);
} /* end of function */
 
void /*FUNCTION*/ danal(
char *routin,
double x,
double u,
double w)
{
	long int _l0;
	double ew;
	static double round = -1.0e0;
 
	if (round < 0.0e0)
	{
		round = DBL_EPSILON;
		printf(" Function                    Result         ---- Not Using ----\n From This                   Using This     --- This Package --\n Package        Argument     Package        Result        Error\n");
	}
	ew = fabs( w - u )/fabs( u*round );
	printf(" %6.6s     %12.4e  %13.6e  %13.6e %9.2e\n", routin, x, u, w, ew);
	return;
} /* end of function */
 
