/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:33:09 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv pf=,p_dckder s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include <stdio.h>
#include <stdlib.h>
#include "p_dckder.h"
#include "drdckder.h"
/*     program DrDCKDER
 *>> 2007-01/02 DRDCKDER Krogh  Put commas around ':' in formats.
 *>> 1996-06-28 DrDCKDER Krogh  Format changes for conversion to C.
 *>> 1994-11-02 DrDCKDER Krogh  Changes to use M77CON
 *>> 1992-04-15 DrDCKDER CLL
 *>> 1992-01-13 C. L. Lawson, JPL.
 *  DRDCKDER..  Demo driver for DCKDER.  Checks derivative calculation.
 *     ------------------------------------------------------------------
 *--D replaces "?": Dr?CKDER, ?CKDER, ?TRG11
 *     ------------------------------------------------------------------ */
		/* PARAMETER translations */
#define	LDFJAC	5
#define	NMAX	5
		/* end of PARAMETER translations */
 
 
int main( )
{
	long int i, imax, j, jmax, mode;
	double fjac[NMAX][LDFJAC], fvec[15], test[NMAX][LDFJAC], tstmax;
	static long m = LDFJAC;
	static long n = NMAX;
	static double x[NMAX]={0.13e0,0.14e0,0.15e0,0.16e0,0.17e0};
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const Fvec = &fvec[0] - 1;
	double *const X = &x[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*     ------------------------------------------------------------------ */
	printf("Program DrDCKDER..  Demo driver for DCKDER.\n");
	dtrg11( n, x, fvec, (double*)fjac, 2 );
	mode = 1;
L_10:
	;
	dckder( &mode, m, n, x, fvec, (double*)fjac, LDFJAC, (double*)test,
	 &imax, &jmax, &tstmax );
	if (mode == 2)
	{
		dtrg11( n, x, fvec, (double*)fjac, 1 );
		goto L_10;
	}
 
	dtrg11( n, x, fvec, (double*)fjac, 1 );
	printf("\n           X(J) =");
	for (j = 1; j <= n; j++)
	{
		printf("%11.3g", X[j]);
	}
	printf("\n");
	printf("\n   I    FVEC(I)   .....................FJAC(I,J)........................\n\n");
	for (i = 1; i <= m; i++)
	{
		printf(" %3ld %11.3g", i, Fvec[i]);
		printf(" ");
		for (j = 1; j <= n; j++)
		{
			printf("%11.3g", fjac[j - 1][i - 1]);
		}
		printf("\n");
	}
 
	printf("\n TEST(,):\n\n");
	for (i = 1; i <= m; i++)
	{
		printf(" %3ld", i);
		printf("             ");
		for (j = 1; j <= n; j++)
		{
			printf("%11.3g", test[j - 1][i - 1]);
		}
		printf("\n");
	}
	printf("\n IMAX =%3ld,    JMAX =%3ld,    TSTMAX =%11.3g\n", imax, jmax, tstmax);
	exit(0);
} /* end of function */
/*     ================================================================== */
void /*FUNCTION*/ dtrg11(
long n,
double x[],
double fvec[],
double *fjac,
long iflag)
{
#define FJAC(I_,J_)	(*(fjac+(I_)*(n)+(J_)))
	long int i, j;
	double sum, temp;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const Fvec = &fvec[0] - 1;
	double *const X = &x[0] - 1;
		/* end of OFFSET VECTORS */
 
	/*     Trigonometric test case No. 11 from MINPACK test set developed by
	 *     J. J. More', B. S. Garbow, and K. E. Hillstrom, Argonne National
	 *     Laboratories, 1980.
	 *     ------------------------------------------------------------------ */
	/*     ------------------------------------------------------------------ */
	if (iflag == 1)
	{
		/*                                        Compute function vector. */
		sum = 0.0e0;
		for (j = 1; j <= n; j++)
		{
			Fvec[j] = cos( X[j] );
			sum += Fvec[j];
		}
		for (j = 1; j <= n; j++)
		{
			Fvec[j] = (double)( n + j ) - sin( X[j] ) - sum - (double)( j )*
			 Fvec[j];
		}
	}
	else if (iflag == 2)
	{
		/*                                        Compute Jacobian matrix. */
		for (j = 1; j <= n; j++)
		{
			temp = sin( X[j] );
			for (i = 1; i <= n; i++)
			{
				FJAC(j - 1,i - 1) = temp;
			}
			FJAC(j - 1,j - 1) = (double)( j + 1 )*temp - cos( X[j] );
		}
	}
	return;
#undef	FJAC
} /* end of function */
 
