/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:31:55 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dcspxx.h"
#include <float.h>
#include <stdlib.h>
double /*FUNCTION*/ dcspxx(
double x)
{
	long int _l0, j, k, n;
	double dcspxx_v, f, g;
	static double bigx = -1.0e0;
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 2001-07-16 DCSPXX Krogh  -1.0 changed to -1.D0.
	 *>> 1998-10-29 DCSPXX Krogh  Moved external statement up for mangle.
	 *>> 1996-01-08 DCSPXX WV Snyder Original code
	 *--D replaces "?": ?CSPXX, ?COSPX, ?SINPX */
	/* COS(PI * X * X / 2) carefully to avoid loss of precision for large X */
	/* DCOSPX is used to compute COS(PI * X) */
	/* BIGX = 1 / round-off = biggest integer exactly representable by F.P.
	 *    If X > BIGX then to the working precision x**2 is an integer (which
	 *    we assume to be a multiple of four), so cos(pi/2 * x**2) = 1.
	 * N = [X], and later [K F]
	 * F = X - N = fractional part of X
	 * K = [ N / 2 ]
	 * J = N mod 2
	 * M = [K F]
	 * G = K F - M = fractional part of K F */
	if (bigx < 0.0e0)
		bigx = 1.0e0/DBL_EPSILON;
	f = fabs( x );
	if (f > bigx)
	{
		/*       Assume x is an even integer. */
		dcspxx_v = 1.0e0;
		return( dcspxx_v );
	}
	n = f;
	f -= n;
	k = n/2;
	j = n%2;
	g = k*f;
	n = g;
	g -= n;
	if (j == 0)
	{
		dcspxx_v = dcospx( 0.5e0*f*f + g + g );
	}
	else
	{
		dcspxx_v = -dsinpx( 0.5e0*f*f + f + g + g );
	}
	return( dcspxx_v );
} /* end of function */
 
