/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:04 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dcpval.h"
#include <stdlib.h>
double /*FUNCTION*/ dcpval(
double p[],
long ndegp,
double x)
{
	long int j;
	double dcpval_v, s, s2, w[3];
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const P = &p[0] - 1;
	double *const W = &w[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1994-10-20 DCPVAL Krogh  Changes to use M77CON
	 *>> 1994-04-20 DCPVAL CLL Edited to make DP & SP files similar.
	 *>> 1987-12-09 DCPVAL Lawson  Initial code.
	 *--D replaces "?": ?CPVAL
	 *
	 *     C.L.LAWSON,JPL, 1969 DEC 17   MODIFIED 1973 JULY 24
	 *
	 *     MODIFIED 1974 NOV 19
	 *
	 *     EVALUATE A POLYNOMIAL OF DEGREE NDEGP GIVEN TRANSFORMATION
	 *     PARAMETERS, P(1) AND P(2), AND COEFFICIENTS RELATIVE TO THE
	 *     CHEBYSHEV BASIS.
	 *
	 *     NDEGP               DEGREE OF POLYNOMIAL
	 *     (P(I),I=1,NDEGP+3)  PARAMETERS DEFINING THE POLYNOMIAL
	 *     X                  INPUT ARGUMENT
	 *             THE POLYNOMIAL'S VALUE AT X IS DEFINED AS FOLLOWS.
	 *
	 *                             S = ( X - P(1) ) / P(2)
	 *
	 *                DCPVAL=SUM OF P(I+3)*T(I,S) FOR I=0,1,...NDEGP
	 *
	 *                             WHERE T(I,S) DENOTES THE CHEBYSHEV
	 *                             POLYNOMIAL OF DEGREE I EVALUATED AT S .
	 * */
	W[1] = 0.0e0;
	W[2] = 0.0e0;
	/*                             TRANSFORM X TO S */
	s = (x - P[1])/P[2];
	s2 = s + s;
 
	/*                             EVALUATE POLYNOMIAL USING RECURSION
	 * */
	for (j = ndegp + 3; j >= 4; j--)
	{
		W[3] = W[2];
		W[2] = W[1];
		W[1] = (s2*W[2] - W[3]) + P[j];
	}
	dcpval_v = (s*W[1] - W[2]) + P[3];
	return( dcpval_v );
} /* end of function */
 
