/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:04 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dcopy.h"
#include <stdlib.h>
void /*FUNCTION*/ dcopy(
long n,
double x[],
long incx,
double y[],
long incy)
{
	long int _d_l, _d_m, _do0, _do1, i, ix, iy, m, ns;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const X = &x[0] - 1;
	double *const Y = &y[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 2006-06-07 DCOPY  Krogh   Removed arithmetic ifs
	 *>> 1994-11-11 DCOPY  Krogh   Declared all vars.
	 *>> 1994-10-20 DCOPY  Krogh   Changes to use M77CON
	 *>> 1989-05-12 DCOPY  Snyder  Clean up a little for F77
	 *>> 1985-08-02 DCOPY  Lawson  Initial code.
	 *--D replaces "?": ?COPY
	 *
	 *     COPY X TO Y.
	 *     FOR I = 0 TO N-1, COPY X(LX+I*INCX) TO Y(LY+I*INCY),
	 *     WHERE LX = 1 IF INCX .GE. 0, ELSE LX = (-INCX)*N, AND LY IS
	 *     DEFINED IN A SIMILAR WAY USING INCY.
	 * */
 
	if (n <= 0)
		return;
	if ((incx != incy) || (incx < 0))
	{
		/*        CODE FOR UNEQUAL OR NONPOSITIVE INCREMENTS. */
		ix = 1;
		iy = 1;
		if (incx < 0)
			ix = (-n + 1)*incx + 1;
		if (incy < 0)
			iy = (-n + 1)*incy + 1;
		for (i = 1; i <= n; i++)
		{
			Y[iy] = X[ix];
			ix += incx;
			iy += incy;
		}
	}
	else if (incx == 1)
	{
		/*        CODE FOR BOTH INCREMENTS EQUAL TO 1
		 *        CLEAN-UP LOOP SO REMAINING VECTOR LENGTH IS A MULTIPLE OF 8. */
		m = n%8;
		for (i = 1; i <= m; i++)
		{
			Y[i] = X[i];
		}
		for (i = m + 1; i <= n; i += 8)
		{
			Y[i] = X[i];
			Y[i + 1] = X[i + 1];
			Y[i + 2] = X[i + 2];
			Y[i + 3] = X[i + 3];
			Y[i + 4] = X[i + 4];
			Y[i + 5] = X[i + 5];
			Y[i + 6] = X[i + 6];
			Y[i + 7] = X[i + 7];
		}
	}
	else
	{
		/*        CODE FOR EQUAL, POSITIVE, NONUNIT INCREMENTS. */
		ns = n*incx;
		for (i = 1, _do0=DOCNT(i,ns,_do1 = incx); _do0 > 0; i += _do1, _do0--)
		{
			Y[i] = X[i];
		}
	}
	return;
} /* end of function */
 
