/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:32:02 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "dbesj1.h"
#include <float.h>
#include <stdlib.h>
double /*FUNCTION*/ dbesj1(
double x)
{
	long int _l0;
	double ampl, dbesj1_v, theta, y;
	static double bj1cs[19]={-.117261415133327865606240574524003e0,
	 -.253615218307906395623030884554698e0,.501270809844695685053656363203743e-1,
	 -.463151480962508191842619728789772e-2,.247996229415914024539124064592364e-3,
	 -.867894868627882584521246435176416e-5,.214293917143793691502766250991292e-6,
	 -.393609307918317979229322764073061e-8,.559118231794688004018248059864032e-10,
	 -.632761640466139302477695274014880e-12,.584099161085724700326945563268266e-14,
	 -.448253381870125819039135059199999e-16,.290538449262502466306018688000000e-18,
	 -.161173219784144165412118186666666e-20,.773947881939274637298346666666666e-23,
	 -.324869378211199841143466666666666e-25,.120223767722741022720000000000000e-27,
	 -.395201221265134933333333333333333e-30,.116167808226645333333333333333333e-32};
	static long ntj1 = 0;
	static double xsml = 0.e0;
	static double xmin = 0.e0;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	double *const Bj1cs = &bj1cs[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1996-03-30 DBESJ1 Krogh  Added external statement.
	 *>> 1995-11-13 DBESJ1 Krogh  Changed data statment for C converstion.
	 *>> 1995-11-03 DBESJ1 Krogh  Removed blanks in numbers for C conversion.
	 *>> 1994-11-11 DBESJ1 Krogh   Declared all vars.
	 *>> 1994-10-20 DBESJ1 Krogh  Changes to use M77CON
	 *>> 1992-02-07 DBESJ1 WV Snyder Correct sign for X < 0.
	 *>> 1990-11-29 DBESJ1 CLL
	 *>> 1985-08-02 DBESJ1 Lawson  Initial code.
	 * JUNE 1978 EDITION.  W. FULLERTON, C3, LOS ALAMOS SCIENTIFIC LAB.
	 * C.L.LAWSON & S.CHAN, JPL, 1984 FEB ADAPTED TO JPL MATH77 LIBRARY.
	 *     ------------------------------------------------------------------
	 *--D replaces "?": ?BESJ1, ?BMP1, ?INITS, ?CSEVL
	 *     ------------------------------------------------------------------ */
 
	/* SERIES FOR BJ1        ON THE INTERVAL  0.          TO  1.60000D+01
	 *                                        WITH WEIGHTED ERROR   1.16D-33
	 *                                         LOG WEIGHTED ERROR  32.93
	 *                               SIGNIFICANT FIGURES REQUIRED  32.36
	 *                                    DECIMAL PLACES REQUIRED  33.57
	 * */
 
 
	/*     ------------------------------------------------------------------ */
	if (ntj1 == 0)
	{
		dinits( bj1cs, 19, 0.1e0*DBL_EPSILON/FLT_RADIX, &ntj1 );
		xsml = sqrt( 4.0e0*DBL_EPSILON/FLT_RADIX );
		xmin = 2.0e0*DBL_MIN;
	}
 
	y = fabs( x );
 
	if (y <= xmin)
	{
		dbesj1_v = 0.e0;
	}
	else if (y <= xsml)
	{
		dbesj1_v = .5e0*x;
	}
	else if (y <= 4.e0)
	{
		dbesj1_v = x*(.25e0 + dcsevl( .125e0*y*y - 1.e0, bj1cs, ntj1 ));
	}
	else
	{
		dbmp1( y, &ampl, &theta );
		dbesj1_v = ampl*cos( theta );
		if (x < 0.0e0)
			dbesj1_v = -dbesj1_v;
	}
 
	return( dbesj1_v );
} /* end of function */
 
