/*Translated by FOR_C, v3.4.2 (-), on 07/09/115 at 08:30:03 */
/*FOR_C Options SET: ftn=u io=c no=p op=aimnv s=dbov str=l x=f - prototypes */
#include <math.h>
#include "fcrt.h"
#include "cquo.h"
#include <stdlib.h>
		/* PARAMETER translations */
#define	ONE	1.0e0
		/* end of PARAMETER translations */
 
void /*FUNCTION*/ cquo(
float cnum[],
float cdenom[],
float cquot[])
{
	float a1, b1, c1, d1, denom;
		/* OFFSET Vectors w/subscript range: 1 to dimension */
	float *const Cdenom = &cdenom[0] - 1;
	float *const Cnum = &cnum[0] - 1;
	float *const Cquot = &cquot[0] - 1;
		/* end of OFFSET VECTORS */
 
	/* Copyright (c) 1996 California Institute of Technology, Pasadena, CA.
	 * ALL RIGHTS RESERVED.
	 * Based on Government Sponsored Research NAS7-03001.
	 *>> 1995-10-30 CQUO  Krogh   Fixed so M77CON can get S.P. for C conv.
	 *>> 1987-12-07 CQUO  Lawson  Initial code.
	 *--C replaces "?": ?QUO
	 *
	 *     Computes the quotient of two double precision complex numbers.
	 *     Computes Z = U / V where the data is given as
	 *        CNUM(1)   = Real part of U
	 *        CNUM(2)   = Imaginary part of U
	 *        CDENOM(1) = Real part of V
	 *        CDENOM(2) = Imaginary part of V
	 *     Result returned as
	 *        CQUOT(1)  = Real part of Z
	 *        CQUOT(2)  = Imaginary part of Z
	 *
	 *     If CDENOM = (0,0) this subr will divide by zero.  We assume this
	 *     will activate a system error stop.
	 *     C.L.Lawson & S.Chan, JPL, June 3,1986. 2/17/87.
	 *     ------------------------------------------------------------------
	 * */
 
	if (fabsf( Cdenom[1] ) > fabsf( Cdenom[2] ))
	{
		a1 = Cnum[1]/Cdenom[1];
		b1 = Cnum[2]/Cdenom[1];
		d1 = Cdenom[2]/Cdenom[1];
		denom = ONE + d1*d1;
		Cquot[1] = (a1 + b1*d1)/denom;
		Cquot[2] = (b1 - a1*d1)/denom;
	}
	else
	{
		a1 = Cnum[1]/Cdenom[2];
		b1 = Cnum[2]/Cdenom[2];
		c1 = Cdenom[1]/Cdenom[2];
		denom = ONE + c1*c1;
		Cquot[1] = (a1*c1 + b1)/denom;
		Cquot[2] = (b1*c1 - a1)/denom;
	}
	return;
} /* end of function */
 
