      SUBROUTINE ZERRHS( PATH, NUNIT )
*
*  -- LAPACK test routine (version 3.1) --
*     Univ. of Tennessee, Univ. of California Berkeley and NAG Ltd..
*     November 2006
*
*     .. Scalar Arguments ..
      CHARACTER*3        PATH
      INTEGER            NUNIT
*     ..
*
*  Purpose
*  =======
*
*  ZERRHS tests the error exits for czgebak, ccgebal, ccgehrd, czunghr,
*  czunmhr, czhseqr, cchsein, and cztrevc.
*
*  Arguments
*  =========
*
*  PATH    (input) CHARACTER*3
*          The LAPACK path name for the routines to be tested.
*
*  NUNIT   (input) INTEGER
*          The unit number for output.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            NMAX, LW
      PARAMETER          ( NMAX = 3, LW = NMAX*NMAX )
*     ..
*     .. Local Scalars ..
      CHARACTER*2        C2
      INTEGER            I, IHI, ILO, INFO, J, M, NT
*     ..
*     .. Local Arrays ..
      LOGICAL            SEL( NMAX )
      INTEGER            IFAILL( NMAX ), IFAILR( NMAX )
      DOUBLE PRECISION   RW( NMAX ), S( NMAX )
      COMPLEX*16         A( NMAX, NMAX ), C( NMAX, NMAX ), TAU( NMAX ),
     $                   VL( NMAX, NMAX ), VR( NMAX, NMAX ), W( LW ),
     $                   X( NMAX )
*     ..
*     .. External Functions ..
      LOGICAL            lsamen
      EXTERNAL           lsamen
*     ..
*     .. External Subroutines ..
      EXTERNAL           CHKXER, czgebak, czgebal, czgehrd, czhsein, 
     $  czhseqr, 
     $                   cztrevc, czunghr, czunmhr
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE
*     ..
*     .. Scalars in Common ..
      LOGICAL            LERR, OK
      CHARACTER*6        SRNAMT
      INTEGER            INFOT, NOUT
*     ..
*     .. Common blocks ..
      COMMON             / INFOC / INFOT, NOUT, OK, LERR
      COMMON             / SRNAMC / SRNAMT
*     ..
*     .. Executable Statements ..
*
      NOUT = NUNIT
      WRITE( NOUT, FMT = * )
      C2 = PATH( 2: 3 )
*
*     Set the variables to innocuous values.
*
      DO 20 J = 1, NMAX
         DO 10 I = 1, NMAX
            A( I, J ) = 1.D0 / DBLE( I+J )
   10    CONTINUE
         SEL( J ) = .TRUE.
   20 CONTINUE
      OK = .TRUE.
      NT = 0
*
*     Test error exits of the nonsymmetric eigenvalue routines.
*
      IF( lsamen( 2, C2, 'HS' ) ) THEN
*
*        czgebal
*
         SRNAMT = 'czgebal'
         INFOT = 1
         CALL czgebal( '/', 0, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'czgebal', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL czgebal( 'N', -1, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'czgebal', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL czgebal( 'N', 2, A, 1, ILO, IHI, S, INFO )
         CALL CHKXER( 'czgebal', INFOT, NOUT, LERR, OK )
         NT = NT + 3
*
*        czgebak
*
         SRNAMT = 'czgebak'
         INFOT = 1
         CALL czgebak( '/', 'R', 0, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'czgebak', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL czgebak( 'N', '/', 0, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'czgebak', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL czgebak( 'N', 'R', -1, 1, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'czgebak', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL czgebak( 'N', 'R', 0, 0, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'czgebak', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL czgebak( 'N', 'R', 0, 2, 0, S, 0, A, 1, INFO )
         CALL CHKXER( 'czgebak', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL czgebak( 'N', 'R', 2, 2, 1, S, 0, A, 2, INFO )
         CALL CHKXER( 'czgebak', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL czgebak( 'N', 'R', 0, 1, 1, S, 0, A, 1, INFO )
         CALL CHKXER( 'czgebak', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL czgebak( 'N', 'R', 0, 1, 0, S, -1, A, 1, INFO )
         CALL CHKXER( 'czgebak', INFOT, NOUT, LERR, OK )
         INFOT = 9
         CALL czgebak( 'N', 'R', 2, 1, 2, S, 0, A, 1, INFO )
         CALL CHKXER( 'czgebak', INFOT, NOUT, LERR, OK )
         NT = NT + 9
*
*        czgehrd
*
         SRNAMT = 'czgehrd'
         INFOT = 1
         CALL czgehrd( -1, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'czgehrd', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL czgehrd( 0, 0, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'czgehrd', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL czgehrd( 0, 2, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'czgehrd', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL czgehrd( 1, 1, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'czgehrd', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL czgehrd( 0, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'czgehrd', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL czgehrd( 2, 1, 1, A, 1, TAU, W, 2, INFO )
         CALL CHKXER( 'czgehrd', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL czgehrd( 2, 1, 2, A, 2, TAU, W, 1, INFO )
         CALL CHKXER( 'czgehrd', INFOT, NOUT, LERR, OK )
         NT = NT + 7
*
*        czunghr
*
         SRNAMT = 'czunghr'
         INFOT = 1
         CALL czunghr( -1, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'czunghr', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL czunghr( 0, 0, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'czunghr', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL czunghr( 0, 2, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'czunghr', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL czunghr( 1, 1, 0, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'czunghr', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL czunghr( 0, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'czunghr', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL czunghr( 2, 1, 1, A, 1, TAU, W, 1, INFO )
         CALL CHKXER( 'czunghr', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL czunghr( 3, 1, 3, A, 3, TAU, W, 1, INFO )
         CALL CHKXER( 'czunghr', INFOT, NOUT, LERR, OK )
         NT = NT + 7
*
*        czunmhr
*
         SRNAMT = 'czunmhr'
         INFOT = 1
         CALL czunmhr( '/', 'N', 0, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL czunmhr( 'L', '/', 0, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL czunmhr( 'L', 'N', -1, 0, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL czunmhr( 'L', 'N', 0, -1, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL czunmhr( 'L', 'N', 0, 0, 0, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL czunmhr( 'L', 'N', 0, 0, 2, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL czunmhr( 'L', 'N', 1, 2, 2, 1, A, 1, TAU, C, 1, W, 2,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL czunmhr( 'R', 'N', 2, 1, 2, 1, A, 1, TAU, C, 2, W, 2,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL czunmhr( 'L', 'N', 1, 1, 1, 0, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL czunmhr( 'L', 'N', 0, 1, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL czunmhr( 'R', 'N', 1, 0, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL czunmhr( 'L', 'N', 2, 1, 1, 1, A, 1, TAU, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL czunmhr( 'R', 'N', 1, 2, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL czunmhr( 'L', 'N', 2, 1, 1, 1, A, 2, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL czunmhr( 'L', 'N', 1, 2, 1, 1, A, 1, TAU, C, 1, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL czunmhr( 'R', 'N', 2, 1, 1, 1, A, 1, TAU, C, 2, W, 1,
     $                INFO )
         CALL CHKXER( 'czunmhr', INFOT, NOUT, LERR, OK )
         NT = NT + 16
*
*        czhseqr
*
         SRNAMT = 'czhseqr'
         INFOT = 1
         CALL czhseqr( '/', 'N', 0, 1, 0, A, 1, X, C, 1, W, 1, INFO )
         CALL CHKXER( 'czhseqr', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL czhseqr( 'E', '/', 0, 1, 0, A, 1, X, C, 1, W, 1, INFO )
         CALL CHKXER( 'czhseqr', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL czhseqr( 'E', 'N', -1, 1, 0, A, 1, X, C, 1, W, 1, INFO )
         CALL CHKXER( 'czhseqr', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL czhseqr( 'E', 'N', 0, 0, 0, A, 1, X, C, 1, W, 1, INFO )
         CALL CHKXER( 'czhseqr', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL czhseqr( 'E', 'N', 0, 2, 0, A, 1, X, C, 1, W, 1, INFO )
         CALL CHKXER( 'czhseqr', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL czhseqr( 'E', 'N', 1, 1, 0, A, 1, X, C, 1, W, 1, INFO )
         CALL CHKXER( 'czhseqr', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL czhseqr( 'E', 'N', 1, 1, 2, A, 1, X, C, 1, W, 1, INFO )
         CALL CHKXER( 'czhseqr', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL czhseqr( 'E', 'N', 2, 1, 2, A, 1, X, C, 2, W, 1, INFO )
         CALL CHKXER( 'czhseqr', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL czhseqr( 'E', 'V', 2, 1, 2, A, 2, X, C, 1, W, 1, INFO )
         CALL CHKXER( 'czhseqr', INFOT, NOUT, LERR, OK )
         NT = NT + 9
*
*        czhsein
*
         SRNAMT = 'czhsein'
         INFOT = 1
         CALL czhsein( '/', 'N', 'N', SEL, 0, A, 1, X, VL, 1, VR, 1, 0,
     $                M, W, RW, IFAILL, IFAILR, INFO )
         CALL CHKXER( 'czhsein', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL czhsein( 'R', '/', 'N', SEL, 0, A, 1, X, VL, 1, VR, 1, 0,
     $                M, W, RW, IFAILL, IFAILR, INFO )
         CALL CHKXER( 'czhsein', INFOT, NOUT, LERR, OK )
         INFOT = 3
         CALL czhsein( 'R', 'N', '/', SEL, 0, A, 1, X, VL, 1, VR, 1, 0,
     $                M, W, RW, IFAILL, IFAILR, INFO )
         CALL CHKXER( 'czhsein', INFOT, NOUT, LERR, OK )
         INFOT = 5
         CALL czhsein( 'R', 'N', 'N', SEL, -1, A, 1, X, VL, 1, VR, 1, 
     $  0, 
     $                M, W, RW, IFAILL, IFAILR, INFO )
         CALL CHKXER( 'czhsein', INFOT, NOUT, LERR, OK )
         INFOT = 7
         CALL czhsein( 'R', 'N', 'N', SEL, 2, A, 1, X, VL, 1, VR, 2, 4,
     $                M, W, RW, IFAILL, IFAILR, INFO )
         CALL CHKXER( 'czhsein', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL czhsein( 'L', 'N', 'N', SEL, 2, A, 2, X, VL, 1, VR, 1, 4,
     $                M, W, RW, IFAILL, IFAILR, INFO )
         CALL CHKXER( 'czhsein', INFOT, NOUT, LERR, OK )
         INFOT = 12
         CALL czhsein( 'R', 'N', 'N', SEL, 2, A, 2, X, VL, 1, VR, 1, 4,
     $                M, W, RW, IFAILL, IFAILR, INFO )
         CALL CHKXER( 'czhsein', INFOT, NOUT, LERR, OK )
         INFOT = 13
         CALL czhsein( 'R', 'N', 'N', SEL, 2, A, 2, X, VL, 1, VR, 2, 1,
     $                M, W, RW, IFAILL, IFAILR, INFO )
         CALL CHKXER( 'czhsein', INFOT, NOUT, LERR, OK )
         NT = NT + 8
*
*        cztrevc
*
         SRNAMT = 'cztrevc'
         INFOT = 1
         CALL cztrevc( '/', 'A', SEL, 0, A, 1, VL, 1, VR, 1, 0, M, W, 
     $  RW, 
     $                INFO )
         CALL CHKXER( 'cztrevc', INFOT, NOUT, LERR, OK )
         INFOT = 2
         CALL cztrevc( 'L', '/', SEL, 0, A, 1, VL, 1, VR, 1, 0, M, W, 
     $  RW, 
     $                INFO )
         CALL CHKXER( 'cztrevc', INFOT, NOUT, LERR, OK )
         INFOT = 4
         CALL cztrevc( 'L', 'A', SEL, -1, A, 1, VL, 1, VR, 1, 0, M, W,
     $                RW, INFO )
         CALL CHKXER( 'cztrevc', INFOT, NOUT, LERR, OK )
         INFOT = 6
         CALL cztrevc( 'L', 'A', SEL, 2, A, 1, VL, 2, VR, 1, 4, M, W, 
     $  RW, 
     $                INFO )
         CALL CHKXER( 'cztrevc', INFOT, NOUT, LERR, OK )
         INFOT = 8
         CALL cztrevc( 'L', 'A', SEL, 2, A, 2, VL, 1, VR, 1, 4, M, W, 
     $  RW, 
     $                INFO )
         CALL CHKXER( 'cztrevc', INFOT, NOUT, LERR, OK )
         INFOT = 10
         CALL cztrevc( 'R', 'A', SEL, 2, A, 2, VL, 1, VR, 1, 4, M, W, 
     $  RW, 
     $                INFO )
         CALL CHKXER( 'cztrevc', INFOT, NOUT, LERR, OK )
         INFOT = 11
         CALL cztrevc( 'L', 'A', SEL, 2, A, 2, VL, 2, VR, 1, 1, M, W, 
     $  RW, 
     $                INFO )
         CALL CHKXER( 'cztrevc', INFOT, NOUT, LERR, OK )
         NT = NT + 7
      END IF
*
*     Print a summary line.
*
      IF( OK ) THEN
         WRITE( NOUT, FMT = 9999 )PATH, NT
      ELSE
         WRITE( NOUT, FMT = 9998 )PATH
      END IF
*
 9999 FORMAT( 1X, A3, ' routines passed the tests of the error exits',
     $      ' (', I3, ' tests done)' )
 9998 FORMAT( ' *** ', A3, ' routines failed the tests of the error ',
     $      'exits ***' )
*
      RETURN
*
*     End of ZERRHS
*
      END
