/*
 * lapack_zlaswp.c
 *
 *This program is a C interface to zlaswp.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_zlaswp(const int n, void * a, const int lda, const int k1, const int k2, const int * ipiv, const int incx )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_lda=lda, F77_k1=k1, F77_k2=k2, F77_incx=incx;
	int i_local;
	F77_INT F77_ipiv[k2*abs(incx)*1];
	for(i_local=0;i_local<k2*abs(incx)*1;i_local++) {
		F77_ipiv[i_local]=(F77_INT) ipiv[i_local];
	}
#else
	#define F77_n n
	#define F77_lda lda
	#define F77_k1 k1
	#define F77_k2 k2
	#define F77_ipiv ipiv
	#define F77_incx incx
#endif

	f77_zlaswp(&F77_n, a, &F77_lda, &F77_k1, &F77_k2, F77_ipiv, &F77_incx);

#ifdef F77_INT
#endif

}
