/*
 * lapack_zcgesv.c
 *
 *This program is a C interface to zcgesv.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_zcgesv(const int n, const int nrhs, void * a, const int lda, int * ipiv, const void * b, const int ldb, void * x, const int ldx, void * work, void * swork, int * iter, int * info )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_nrhs=nrhs, F77_lda=lda, F77_ldb=ldb, F77_ldx=ldx;
	int i_local;
	F77_INT F77_ipiv[n*1];
	for(i_local=0;i_local<n*1;i_local++) {
		F77_ipiv[i_local]=(F77_INT) ipiv[i_local];
	}
	F77_INT F77_iter[1];
	F77_INT F77_info[1];
#else
	#define F77_n n
	#define F77_nrhs nrhs
	#define F77_lda lda
	#define F77_ipiv ipiv
	#define F77_ldb ldb
	#define F77_ldx ldx
	#define F77_iter iter
	#define F77_info info
#endif

	f77_zcgesv(&F77_n, &F77_nrhs, a, &F77_lda, F77_ipiv, b, &F77_ldb, x, &F77_ldx, work, swork, F77_iter, F77_info);

#ifdef F77_INT
	for(i_local=0;i_local<n*1;i_local++) {
		ipiv[i_local]=(int) F77_ipiv[i_local];
	}

	iter[0]=(int) F77_iter[0];
	info[0]=(int) F77_info[0];
#endif

}
