/*
 * lapack_slarrk.c
 *
 *This program is a C interface to slarrk.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_slarrk(const int n, const int iw, const float gl, const float gu, const float * d, const float * e2, const float pivmin, const float reltol, float * w, float * werr, int * info )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_iw=iw;
	int i_local;
	F77_INT F77_info[1];
#else
	#define F77_n n
	#define F77_iw iw
	#define F77_info info
#endif

	f77_slarrk(&F77_n, &F77_iw, &gl, &gu, d, e2, &pivmin, &reltol, w, werr, F77_info);

#ifdef F77_INT
	info[0]=(int) F77_info[0];
#endif

}
