/*
 * lapack_slarre.c
 *
 *This program is a C interface to slarre.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_slarre(const char * range, const int n, float * vl, float * vu, const int il, const int iu, float * d, float * e, float * e2, const float rtol1, const float rtol2, const float spltol, int * nsplit, int * isplit, int * m, float * w, float * werr, float * wgap, int * iblock, int * indexw, float * gers, double * pivmin, float * work, int * iwork, int * info )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_il=il, F77_iu=iu;
	int i_local;
	F77_INT F77_nsplit[1];
	F77_INT F77_isplit[n*1];
	for(i_local=0;i_local<n*1;i_local++) {
		F77_isplit[i_local]=(F77_INT) isplit[i_local];
	}
	F77_INT F77_m[n*1];
	for(i_local=0;i_local<n*1;i_local++) {
		F77_m[i_local]=(F77_INT) m[i_local];
	}
	F77_INT F77_iblock[n*1];
	for(i_local=0;i_local<n*1;i_local++) {
		F77_iblock[i_local]=(F77_INT) iblock[i_local];
	}
	F77_INT F77_indexw[n*1];
	for(i_local=0;i_local<n*1;i_local++) {
		F77_indexw[i_local]=(F77_INT) indexw[i_local];
	}
	#define F77_iwork iwork
	F77_INT F77_info[1];
#else
	#define F77_n n
	#define F77_il il
	#define F77_iu iu
	#define F77_nsplit nsplit
	#define F77_isplit isplit
	#define F77_m m
	#define F77_iblock iblock
	#define F77_indexw indexw
	#define F77_iwork iwork
	#define F77_info info
#endif

#ifdef F77_CHAR
	F77_CHAR F77_range = C2F_STR(range, strlen(range)) ;
#else
	#define F77_range range
#endif

	f77_slarre(range, &F77_n, vl, vu, &F77_il, &F77_iu, d, e, e2, &rtol1, &rtol2, &spltol, F77_nsplit, F77_isplit, F77_m, w, werr, wgap, F77_iblock, F77_indexw, gers, pivmin, work, F77_iwork, F77_info);

#ifdef F77_INT
	nsplit[0]=(int) F77_nsplit[0];
	for(i_local=0;i_local<n*1;i_local++) {
		isplit[i_local]=(int) F77_isplit[i_local];
	}

	for(i_local=0;i_local<n*1;i_local++) {
		m[i_local]=(int) F77_m[i_local];
	}

	for(i_local=0;i_local<n*1;i_local++) {
		iblock[i_local]=(int) F77_iblock[i_local];
	}

	for(i_local=0;i_local<n*1;i_local++) {
		indexw[i_local]=(int) F77_indexw[i_local];
	}

	info[0]=(int) F77_info[0];
#endif

}
