/*
 * lapack_slarrd.c
 *
 *This program is a C interface to slarrd.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_slarrd(const char * range, const char * order, const int n, const float vl, const float vu, const int il, const int iu, const float * gers, const float reltol, const float * d, const float * e, const float * e2, const float pivmin, const int nsplit, const int * isplit, int * m, float * w, float * werr, float * wl, float * wu, int * iblock, int * indexw, float * work, int * iwork, int * info )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_il=il, F77_iu=iu, F77_nsplit=nsplit;
	int i_local;
	F77_INT F77_isplit[n*1];
	for(i_local=0;i_local<n*1;i_local++) {
		F77_isplit[i_local]=(F77_INT) isplit[i_local];
	}
	F77_INT F77_m[n*1];
	for(i_local=0;i_local<n*1;i_local++) {
		F77_m[i_local]=(F77_INT) m[i_local];
	}
	F77_INT F77_iblock[n*1];
	for(i_local=0;i_local<n*1;i_local++) {
		F77_iblock[i_local]=(F77_INT) iblock[i_local];
	}
	F77_INT F77_indexw[n*1];
	for(i_local=0;i_local<n*1;i_local++) {
		F77_indexw[i_local]=(F77_INT) indexw[i_local];
	}
	#define F77_iwork iwork
	F77_INT F77_info[1];
#else
	#define F77_n n
	#define F77_il il
	#define F77_iu iu
	#define F77_nsplit nsplit
	#define F77_isplit isplit
	#define F77_m m
	#define F77_iblock iblock
	#define F77_indexw indexw
	#define F77_iwork iwork
	#define F77_info info
#endif

#ifdef F77_CHAR
	F77_CHAR F77_range = C2F_STR(range, strlen(range)) , F77_order = C2F_STR(order, strlen(order)) ;
#else
	#define F77_range range
	#define F77_order order
#endif

	f77_slarrd(range, order, &F77_n, &vl, &vu, &F77_il, &F77_iu, gers, &reltol, d, e, e2, &pivmin, &F77_nsplit, F77_isplit, F77_m, w, werr, wl, wu, F77_iblock, F77_indexw, work, F77_iwork, F77_info);

#ifdef F77_INT
	for(i_local=0;i_local<n*1;i_local++) {
		m[i_local]=(int) F77_m[i_local];
	}

	for(i_local=0;i_local<n*1;i_local++) {
		iblock[i_local]=(int) F77_iblock[i_local];
	}

	for(i_local=0;i_local<n*1;i_local++) {
		indexw[i_local]=(int) F77_indexw[i_local];
	}

	info[0]=(int) F77_info[0];
#endif

}
