/*
 * lapack_slarrb.c
 *
 *This program is a C interface to slarrb.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_slarrb(const int n, const float * d, const float * lld, const int ifirst, const int ilast, const float rtol1, const float rtol2, const int offset, float * w, float * wgap, float * werr, float * work, int * iwork, const double pivmin, const double spdiam, const int twist, int * info )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_ifirst=ifirst, F77_ilast=ilast, F77_offset=offset, F77_twist=twist;
	#define F77_iwork iwork
	int i_local;
	F77_INT F77_info[1];
#else
	#define F77_n n
	#define F77_ifirst ifirst
	#define F77_ilast ilast
	#define F77_offset offset
	#define F77_iwork iwork
	#define F77_twist twist
	#define F77_info info
#endif

	f77_slarrb(&F77_n, d, lld, &F77_ifirst, &F77_ilast, &rtol1, &rtol2, &F77_offset, w, wgap, werr, work, F77_iwork, &pivmin, &spdiam, &F77_twist, F77_info);

#ifdef F77_INT
	info[0]=(int) F77_info[0];
#endif

}
