/*
 * lapack_slaqr5.c
 *
 *This program is a C interface to slaqr5.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_slaqr5(const long int wantt, const long int wantz, const int kacc22, const int n, const int ktop, const int kbot, const int nshfts, const float * sr, const float * si, float * h, const int ldh, const int iloz, const int ihiz, float * z, const int ldz, float * v, const int ldv, float * u, const int ldu, const int nh, float * wh, const int ldwh, const int nv, float * wv, const int ldwv )
{
#ifdef F77_INT
	F77_INT F77_kacc22=kacc22, F77_n=n, F77_ktop=ktop, F77_kbot=kbot, F77_nshfts=nshfts, F77_ldh=ldh, F77_iloz=iloz, F77_ihiz=ihiz, F77_ldz=ldz, F77_ldv=ldv, F77_ldu=ldu, F77_nh=nh, F77_ldwh=ldwh, F77_nv=nv, F77_ldwv=ldwv;
#else
	#define F77_kacc22 kacc22
	#define F77_n n
	#define F77_ktop ktop
	#define F77_kbot kbot
	#define F77_nshfts nshfts
	#define F77_ldh ldh
	#define F77_iloz iloz
	#define F77_ihiz ihiz
	#define F77_ldz ldz
	#define F77_ldv ldv
	#define F77_ldu ldu
	#define F77_nh nh
	#define F77_ldwh ldwh
	#define F77_nv nv
	#define F77_ldwv ldwv
#endif

#ifdef F77_LOG
	F77_LOG F77_wantt=wantt, F77_wantz=wantz;
#else
	#define F77_wantt wantt
	#define F77_wantz wantz
#endif

	f77_slaqr5(&F77_wantt, &F77_wantz, &F77_kacc22, &F77_n, &F77_ktop, &F77_kbot, &F77_nshfts, sr, si, h, &F77_ldh, &F77_iloz, &F77_ihiz, z, &F77_ldz, v, &F77_ldv, u, &F77_ldu, &F77_nh, wh, &F77_ldwh, &F77_nv, wv, &F77_ldwv);

#ifdef F77_INT
#endif

#ifdef F77_LOG
#endif

}
