/*
 * lapack_slaneg.c
 *
 *This program is a C interface to slaneg.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

int lapack_slaneg(const int n, const float * d, const float * lld, const float sigma, const float pivmin, const int r )
{

	int output;

#ifdef F77_INT
	F77_INT F77_n=n, F77_r=r;
#else
	#define F77_n n
	#define F77_r r
#endif

	f77_slaneg(&output, &F77_n, d, lld, &sigma, &pivmin, &F77_r);

#ifdef F77_INT
#endif

return output;
}
