/*
 * lapack_sgetrf.c
 *
 *This program is a C interface to sgetrf.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_sgetrf(const int m, const int n, float * a, const int lda, int * ipiv, int * info )
{
#ifdef F77_INT
	F77_INT F77_m=m, F77_n=n, F77_lda=lda;
	int i_local;
	F77_INT F77_ipiv[min(m,n)*1];
	for(i_local=0;i_local<min(m,n)*1;i_local++) {
		F77_ipiv[i_local]=(F77_INT) ipiv[i_local];
	}
	F77_INT F77_info[1];
#else
	#define F77_m m
	#define F77_n n
	#define F77_lda lda
	#define F77_ipiv ipiv
	#define F77_info info
#endif

	f77_sgetrf(&F77_m, &F77_n, a, &F77_lda, F77_ipiv, F77_info);

#ifdef F77_INT
	for(i_local=0;i_local<min(m,n)*1;i_local++) {
		ipiv[i_local]=(int) F77_ipiv[i_local];
	}

	info[0]=(int) F77_info[0];
#endif

}
