/*
 * lapack_dstemr.c
 *
 *This program is a C interface to dstemr.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_dstemr(const enum lapack_compute_vectors_type jobz, const enum lapack_range_type range, const int n, double * d, double * e, const double vl, const double vu, const int il, const int iu, int * m, double * w, double * z, const int ldz, const int nzc, int * isuppz, long int * tryrac, double * work, const int lwork, int * iwork, const int liwork, int * info )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_il=il, F77_iu=iu, F77_ldz=ldz, F77_nzc=nzc, F77_lwork=lwork, F77_liwork=liwork;
	int i_local;
	F77_INT F77_m[1];
	F77_INT F77_isuppz[1];
	#define F77_iwork iwork
	F77_INT F77_info[1];
#else
	#define F77_n n
	#define F77_il il
	#define F77_iu iu
	#define F77_m m
	#define F77_ldz ldz
	#define F77_nzc nzc
	#define F77_isuppz isuppz
	#define F77_lwork lwork
	#define F77_iwork iwork
	#define F77_liwork liwork
	#define F77_info info
#endif

#ifdef F77_LOG
;
	int j_local;
	F77_LOG F77_tryrac[1];
#else
	#define F77_tryrac tryrac
#endif

#ifdef F77_CHAR
	F77_CHAR F77_jobz, F77_range;
#else
	#define F77_jobz C_jobz
	#define F77_range C_range
#endif

	char C_jobz=' ';
	if (jobz == lapack_no_compute_vectors) {
		 C_jobz = 'N';
	} else if (jobz == lapack_compute_vectors) {
		 C_jobz = 'V';
	}

	char C_range=' ';
	if (range == lapack_range_all) {
		 C_range = 'A';
	} else if (range == lapack_interval) {
		 C_range = 'V';
	} else if (range == lapack_order) {
		 C_range = 'I';
	}

#ifdef F77_CHAR
	F77_jobz = C2F_CHAR(&C_jobz)
	F77_range = C2F_CHAR(&C_range)
#endif

	f77_dstemr(&F77_jobz, &F77_range, &F77_n, d, e, &vl, &vu, &F77_il, &F77_iu, F77_m, w, z, &F77_ldz, &F77_nzc, F77_isuppz, F77_tryrac, work, &F77_lwork, F77_iwork, &F77_liwork, F77_info);

#ifdef F77_INT
	m[0]=(int) F77_m[0];
	isuppz[0]=(int) F77_isuppz[0];
	info[0]=(int) F77_info[0];
#endif

#ifdef F77_LOG
	tryrac[0]=(long int) F77_tryrac[0];

#endif

}
