/*
 * lapack_dlarrj.c
 *
 *This program is a C interface to dlarrj.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_dlarrj(const int n, const double * d, const double * e2, const int ifirst, const int ilast, const double rtol, const int offset, double * w, double * werr, double * work, int * iwork, const double pivmin, const double spdiam, int * info )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_ifirst=ifirst, F77_ilast=ilast, F77_offset=offset;
	#define F77_iwork iwork
	int i_local;
	F77_INT F77_info[1];
#else
	#define F77_n n
	#define F77_ifirst ifirst
	#define F77_ilast ilast
	#define F77_offset offset
	#define F77_iwork iwork
	#define F77_info info
#endif

	f77_dlarrj(&F77_n, d, e2, &F77_ifirst, &F77_ilast, &rtol, &F77_offset, w, werr, work, F77_iwork, &pivmin, &spdiam, F77_info);

#ifdef F77_INT
	info[0]=(int) F77_info[0];
#endif

}
