/*
 * lapack_dlarrf.c
 *
 *This program is a C interface to dlarrf.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_dlarrf(const int n, const double * d, const double * l, const double * ld, const int clstrt, const int clend, const double * w, double * wgap, const double * werr, const double spdiam, const double clgapl, const double clgapr, const double pivmin, double * sigma, double * dplus, double * lplus, double * work )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_clstrt=clstrt, F77_clend=clend;
#else
	#define F77_n n
	#define F77_clstrt clstrt
	#define F77_clend clend
#endif

	f77_dlarrf(&F77_n, d, l, ld, &F77_clstrt, &F77_clend, w, wgap, werr, &spdiam, &clgapl, &clgapr, &pivmin, sigma, dplus, lplus, work);

#ifdef F77_INT
#endif

}
