/*
 * lapack_dlarrc.c
 *
 *This program is a C interface to dlarrc.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_dlarrc(const enum lapack_balance_type jobt, const int n, const double vl, const double vu, const double * d, const double * e, const double pivmin, int * eigcnt, int * lcnt, int * rcnt, int * info )
{
#ifdef F77_INT
	F77_INT F77_n=n;
	int i_local;
	F77_INT F77_eigcnt[1];
	F77_INT F77_lcnt[1];
	F77_INT F77_rcnt[1];
	F77_INT F77_info[1];
#else
	#define F77_n n
	#define F77_eigcnt eigcnt
	#define F77_lcnt lcnt
	#define F77_rcnt rcnt
	#define F77_info info
#endif

#ifdef F77_CHAR
	F77_CHAR F77_jobt;
#else
	#define F77_jobt C_jobt
#endif

	char C_jobt=' ';
	if (jobt == lapack_nothing) {
		 C_jobt = 'N';
	} else if (jobt == lapack_permute) {
		 C_jobt = 'P';
	} else if (jobt == lapack_scale) {
		 C_jobt = 'S';
	} else if (jobt == lapack_permute_scale) {
		 C_jobt = 'B';
	}

#ifdef F77_CHAR
	F77_jobt = C2F_CHAR(&C_jobt)
#endif

	f77_dlarrc(&F77_jobt, &F77_n, &vl, &vu, d, e, &pivmin, F77_eigcnt, F77_lcnt, F77_rcnt, F77_info);

#ifdef F77_INT
	eigcnt[0]=(int) F77_eigcnt[0];
	lcnt[0]=(int) F77_lcnt[0];
	rcnt[0]=(int) F77_rcnt[0];
	info[0]=(int) F77_info[0];
#endif

}
