/*
 * lapack_dlar1v.c
 *
 *This program is a C interface to dlar1v.
 *
 * Written by Remi Delmas.
 *
 */

#include "../include/lapack_f77.h"
#include "../include/lapack_enum.h"
#include "../include/lapack_aux.h"

void lapack_dlar1v(const int n, const int b1, const int bn, const double lambda, const double * l, const double * d, const double * ld, const double * lld, const double pivmin, const double gaptol, double * z, const long int wantnc, int * negcnt, double * ztz, double * mingma, int * r, int * isuppz, double * nrminv, double * resid, double * rqcorr, double * work )
{
#ifdef F77_INT
	F77_INT F77_n=n, F77_b1=b1, F77_bn=bn;
	int i_local;
	F77_INT F77_negcnt[1];
	F77_INT F77_r[1];
	F77_r[0]=(F77_INT) r[0];
	F77_INT F77_isuppz[2*1];
	for(i_local=0;i_local<2*1;i_local++) {
		F77_isuppz[i_local]=(F77_INT) isuppz[i_local];
	}
#else
	#define F77_n n
	#define F77_b1 b1
	#define F77_bn bn
	#define F77_negcnt negcnt
	#define F77_r r
	#define F77_isuppz isuppz
#endif

#ifdef F77_LOG
	F77_LOG F77_wantnc=wantnc;
#else
	#define F77_wantnc wantnc
#endif

	f77_dlar1v(&F77_n, &F77_b1, &F77_bn, &lambda, l, d, ld, lld, &pivmin, &gaptol, z, &F77_wantnc, F77_negcnt, ztz, mingma, F77_r, F77_isuppz, nrminv, resid, rqcorr, work);

#ifdef F77_INT
	negcnt[0]=(int) F77_negcnt[0];
	r[0]=(int) F77_r[0];
	for(i_local=0;i_local<2*1;i_local++) {
		isuppz[i_local]=(int) F77_isuppz[i_local];
	}

#endif

#ifdef F77_LOG
#endif

}
