package AT.Ac.univie.imp.loeffler.util;

/**
 * A class to represent a one-diensional range of integer values.
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */

public class IntRange1D {
     /**
      * construct from lower and upper boundary.
      * <p>
      * It is perfectly legal for lower boundary value to be greater then the upper boundary value.
      * <p>
      * The upper boundary is considered being part of the range.
      *
      * @param lower the lower boundary of the range
      * @param upper the upper boundary of the range
      */
     public IntRange1D(int lower, int upper) {
          this.lower = lower;
          this.upper = upper;
     }

     /**
      * return lower boundary.
      *
      * @return the lower boundary of the range
      */
     public int from() {
          return lower;
     }

     /**
      * return upper boundary.
      *
      * @return the upper boundary of the range
      */
     public int to() {
          return upper;
     }

     /**
      * return the number of integer values lying in the range.
      * <p>
      * The size is defined as lower - upper + 1, i.e. the upper boundary is part of the range.
      *
      * @return the size of the range which is upper - lower + 1
      */
     public int size() {
          return (upper - lower + 1);
     }

     private int lower;
     private int upper;
}
