package AT.Ac.univie.imp.loeffler.util;

/**
 * Some minimal support for "design by contract".
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public final class Contract {
     /**
      * flag that says if the checks are really performed
      */
     private static final boolean DO_IT = false;
     
     /**
      * check if precondition is met and throw exception if not
      *
      * @param condition the precondition that must be met
      * @param msg       if the condition is not met an object of class PreconditionNotMetException is thrown with the
      *                  message "A precondition was not met: " + msg + ".".
      * @exception PreconditionNotMetException if condition is not true
      */
     public static void pre(boolean condition, String msg) {
          if (DO_IT && !condition) throw new PreconditionNotMetException("A precondition was not met: " + msg + ".");
     }
     
     /**
      * check if postcondition is met and throw exception if not
      *
      * @param condition the postcondition that must be met
      * @param msg       if the condition is not met an object of class PostconditionNotMetException is thrown with the
      *                  message "A postcondition was not met: " + msg + ".".
      * @exception PostconditionNotMetException if condition is not true
      */
     public static void post(boolean condition, String msg) {
          if (DO_IT && !condition) throw new PostconditionNotMetException("A postcondition was not met: " + msg + ".");
     }
     
     /**
      * check if a condition is met and throw exception if not
      *
      * @param condition the condition that must be met
      * @param msg       if the condition is not met an object of class AssertionFailedException is thrown with the
      *                  message "An assertion failed: " + msg + ".".
      * @exception AssertionFailedException if condition is not true
      */
     public static void assert(boolean condition, String msg) {
          if (DO_IT && !condition) throw new AssertionFailedException("An assertion failed: " + msg + ".");
     }
}
