package AT.Ac.univie.imp.loeffler.pde.threeD.fd;
import  AT.Ac.univie.imp.loeffler.parallel.*;
import  AT.Ac.univie.imp.loeffler.util.*;

/**
 * A helper class of class SolverThroughSmoother that helps parallelizing method SolverThroughSmoother.solve().
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
final class SolveThroughSmootherParallelizer extends Parallelizer {
     /**
      * construct.
      */
     public SolveThroughSmootherParallelizer(SolverThroughSmoother solver, ConstBoundaryGrid gOld, 
                                             ConstBoundaryGrid gNew) {
          
          this.solver = solver;
          this.gOld   = gOld;
          this.gNew   = gNew;
          
          start();
     }
     
     /**
      * re-route.
      */
     public void runParallel(int myNum, int totalNum) {
          solver.solveProper(gOld,gNew,myNum,totalNum);
     }
     
     private SolverThroughSmoother solver;
     private ConstBoundaryGrid     gOld;
     private ConstBoundaryGrid     gNew;
}
