package AT.Ac.univie.imp.loeffler.pde.threeD.fd;

/**
 * This interface defines the smooth() method which is used for smoothing the approximate solution of a linear elliptic
 * partial differential equation (PDE) on a regular cubic grid in 3D before and/or after going to the next coarser grid 
 * in the Multigrid (MG) algorithm.
 * <p>
 * In the theory of the MG algorithm, smoothing refers to the reduction of the high-frequency components of the error of
 * an approximate solution of a PDE. This is usuallu achieved by applying one or more sweeps of a conventional 
 * relaxation algorithm. This algorithms are usually good in reducing the high-frequency components of the error, but
 * bad in reducing the low-frequency components of the error, which is the reason why they are slow if applied in
 * isolation to solve a PDE. However, this property is important in the context of the MG algorithm.
 * <p>
 * The method smooth() is intended to apply one sweep of a smoothing algorithm.
 *
 * @see FMG
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public interface Smoother {
     /**
      * smooth an approximate solution to a linear elliptic PDE on a regular cubic grid in 3D.
      * <p>
      * Let the elliptic PDE be represented by Ax = f, and let u be an approximation to the exact solution x,
      * then this method smoothes (i.e. reduces the high-frequency components of the error of) u.
      *
      * @see PDE
      *
      * @param u      the approximate solution of the PDE sampled at a grid of a certain size
      * @param f      the right hand side of the PDE sampled at a grid of the same size
      * @return the smmothed approximate solution of the PDE
      */
     BoundaryGrid smooth(ConstBoundaryGrid u, ConstNoBoundaryGrid f);
}
