package AT.Ac.univie.imp.loeffler.pde.threeD.fd;
import  AT.Ac.univie.imp.loeffler.util.*;

/**
 * An implementation of the Red-Black Gauss-Seidel method of relaxing (thereby smoothing) the solution of a linear 
 * elliptic PDE.
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public final class RedBlackGaussSeidel implements Smoother {
     /**
      * construct from PDE.
      *
      * @param pde a representation of the PDE
      */
     public RedBlackGaussSeidel(PDE pde) {
          Contract.pre(pde != null,"pde not null-object");
          
          this.pde = pde;
     }

     /**
      * implements method from Smoother.
      *
      * @see Smoother#smooth
      */
     public BoundaryGrid smooth(ConstBoundaryGrid u, ConstNoBoundaryGrid f) {
          int size = u.size();
          
          Contract.pre(f.size() == size,"size of u equal size of f");
          
          BoundaryGrid g = (BoundaryGrid) u.clone();
          for (int pass = 0; pass <= 1; pass++) {
               for (int x = 1; x < (size - 1); x++) {
                    for (int y = 1; y < (size - 1); y++) {
                         for (int z = 1; z < (size - 1); z++) {
                              if (((x + y + z)%2) != pass) g.set(x,y,z,pde.evaluate(g,f,x,y,z));
                         }
                    }
               }
          }
          return g;
     }

     private PDE    pde;
}
