package AT.Ac.univie.imp.loeffler.pde.threeD.fd;
import  AT.Ac.univie.imp.loeffler.util.*;

/**
 * An implementation of BoundaryGrid where the boundary elements are periodic images of interior grid elements.
 *
 * The exact definition of periodic boundary conditions in this context is that any index equal to 0 will
 * be translated to (size() - 2) and any index equal to (size() - 1) will be translated to 1.
 * This translation is done independently for each index and the resulting interior element is returned as
 * the requested boundary element.
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public final class PeriodicBoundaryGrid extends BoundaryGrid {
     /**
      * construct from size and initial value for all elements in the interior.
      *
      * @param size          the size of the grid
      * @param interiorValue the value to which all interior grid elements will be set
      */
     public PeriodicBoundaryGrid(int size, double interiorValue) {
          super(size,interiorValue);
     }

     /**
      * implements method from ConstGrid.
      *
      * @see ConstGrid#newInstance
      */
     public Grid newInstance(int size, double value) {
          return new PeriodicBoundaryGrid(size,value);
     }

     /**
      * implements method from Grid.
      *
      * @see Grid#getBoundary
      */
     protected double getBoundary(int x, int y, int z) {
          Contract.pre(isBoundary(x,y,z),"grid element must be part of the boundary");

          if      (x == 0)       x = s - 2;
          else if (x == (s - 1)) x = 1;
          if      (y == 0)       y = s - 2;
          else if (y == (s - 1)) y = 1;
          if      (z == 0)       z = s - 2;
          else if (z == (s - 1)) z = 1;
          
          return g[x][y][z];
     }
}
