package AT.Ac.univie.imp.loeffler.pde.threeD.fd;
import  AT.Ac.univie.imp.loeffler.util.*;

/**
 * An implementation of class Grid where no boundary is allowed.
 *
 * @author Gerald Loeffler (Gerald.Loeffler@univie.ac.at)
 */
public final class NoBoundaryGrid extends Grid implements ConstNoBoundaryGrid {
     /**
      * construct from size and initial value for all elements in the interior.
      *
      * @param size          the size of the grid ( > 0)
      * @param interiorValue the initial value to which all grid elements will be set
      */
     public NoBoundaryGrid(int size, double interiorValue) {
          super(size,interiorValue);
     }

     /**
      * implements method from ConstGrid.
      *
      * @see ConstGrid#newInstance
      */
     public Grid newInstance(int size, double value) {
          Contract.pre(size > 0,"size > 0");
          
          return new NoBoundaryGrid(size,value);
     }

     /**
      * implements method from Grid.
      * <p>
      * Since objects of class NoBoundaryGrid don't have a boundary, this method simply throws an exception.
      *
      * @see Grid#getBoundary
      */
     protected double getBoundary(int x, int y, int z) {
          throw new IndexOutOfBoundsException("This grid does not have a boundary.");
     }
}
